/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.function;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import org.talend.maplang.el.interpreter.impl.function.AbstractExprLangFunction;
import org.talend.maplang.el.interpreter.impl.function.TimeoutCharSequence;
import org.talend.trr.runtime.function.FunctionException;

public class Matches
extends AbstractExprLangFunction {
    private static final int INPUT_INDEX = 0;
    private static final int REGEX_INDEX = 1;
    private static final int CASE_INSENSITIVE_INDEX = 2;
    private static final int DOTALL_INDEX = 3;
    private static final int TIMEOUT_INDEX = 4;
    private static final String NAME = "matches";
    public static final boolean CASE_INSENSITIVE = true;
    public static final boolean DOTALL = true;

    public Matches() {
        super(NAME);
    }

    @Override
    public Object call(Object ... arguments) {
        this.checkNbrOfArguments(arguments, 2, 5);
        this.checkArgumentsNotNull(arguments);
        CharSequence input = this.getInput(arguments);
        this.checkArgumentClass(arguments, 1, (Class<?>)String.class);
        String regex = arguments[1].toString();
        int flags = 0;
        if (arguments.length > 2) {
            this.checkArgumentClass(arguments, 2, (Class<?>)Boolean.class);
            if (((Boolean)arguments[2]).booleanValue()) {
                flags |= 1;
            }
        }
        if (arguments.length > 3) {
            this.checkArgumentClass(arguments, 3, (Class<?>)Boolean.class);
            if (((Boolean)arguments[3]).booleanValue()) {
                flags |= 2;
            }
        }
        if (arguments.length > 4) {
            this.checkArgumentClass(arguments, 4, (Class<?>)Long.class);
        }
        try {
            Pattern pattern = Pattern.compile((String)regex, (int)flags);
            Matcher matcher = pattern.matcher(input);
            return matcher.matches();
        }
        catch (PatternSyntaxException e) {
            throw new FunctionException("Unable to parse the regexp", e);
        }
    }

    private CharSequence getInput(Object ... arguments) {
        String inner = arguments[0].toString();
        if (arguments.length > 4) {
            this.checkArgumentClass(arguments, 4, (Class<?>)Long.class);
            return new TimeoutCharSequence(inner, (Long)arguments[4]);
        }
        return new TimeoutCharSequence(inner, 10000L);
    }
}

