/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.function;

import java.net.URL;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverriddenFunctionClassLoader
extends ClassLoader {
    private static final Logger LOG = LoggerFactory.getLogger(OverriddenFunctionClassLoader.class);
    private static final String OVERRIDDEN_FUNCTIONS_FILE = "overridden_functions";

    @Override
    public Enumeration<URL> getResources(String name) {
        return new Enumeration<URL>(){
            private boolean done = false;

            @Override
            public boolean hasMoreElements() {
                return !this.done;
            }

            @Override
            public URL nextElement() {
                this.done = true;
                URL url = Thread.currentThread().getContextClassLoader().getResource(OverriddenFunctionClassLoader.OVERRIDDEN_FUNCTIONS_FILE);
                if (url == null) {
                    throw new IllegalStateException(String.format("Resource not found: \"%s\"", OverriddenFunctionClassLoader.OVERRIDDEN_FUNCTIONS_FILE));
                }
                LOG.debug("Found URL: {}", (Object)url);
                return url;
            }
        };
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        LOG.debug("Trying to load class {}", (Object)name);
        return Thread.currentThread().getContextClassLoader().loadClass(name);
    }
}

