/*
 * Decompiled with CFR 0.152.
 */
package org.talend.trr.runtime.model;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.talend.trr.runtime.model.ParameterType;

public class Parameter
implements Serializable {
    private String name;
    private String value;
    private ParameterType type;

    @ConstructorProperties(value={"name", "value", "type"})
    public Parameter(String name, String value, ParameterType type) {
        this.setName(name);
        this.setValue(value);
        this.setType(type);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("The 'name' should not be empty.");
        }
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (StringUtils.isBlank(value)) {
            throw new IllegalArgumentException("The 'value' should not be empty.");
        }
        this.value = value;
    }

    public ParameterType getType() {
        return this.type;
    }

    public void setType(ParameterType type) {
        this.type = type;
    }

    public boolean isColumn() {
        return ParameterType.COLUMN.equals((Object)this.type);
    }

    public boolean isVal() {
        return ParameterType.VAL.equals((Object)this.type);
    }

    public String toString() {
        return "Parameter{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }
}

