/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.dictionary.provider.config;

import org.springframework.web.client.RestTemplate;
import org.talend.dataquality.semantic.api.CategoryRegistryManager;
import org.talend.dataquality.semantic.api.DeletableDictionarySnapshotOpener;
import org.talend.dataquality.semantic.api.SemanticProperties;
import org.talend.dataquality.semantic.snapshot.SharedDictionary;
import org.talend.tsd.artifact.client.api.SemanticBundlesApi;
import org.talend.tsd.connector.config.RestTemplateConnectorAutoConfiguration;
import org.talend.tsd.dictionary.provider.config.DictionaryProviderProperties;
import org.talend.tsd.dictionary.provider.service.IndexFolderProvider;
import org.talend.tsd.dictionary.provider.service.RestTemplateDictionaryProvider;
import org.talend.tsd.maven.connector.resttemplate.client.HttpClient;
import org.talend.tsd.maven.connector.resttemplate.config.RestTemplateConnectorProperties;
import org.talend.tsd.maven.connector.resttemplate.service.RestTemplateArtifactService;
import org.talend.tsd.maven.connector.resttemplate.service.RestTemplateJarClient;
import org.talend.tsd.maven.connector.service.JarService;
import org.talend.tsd.utils.RandomFolderNameProvider;

public class RestTemplateDictionaryProviderConfig {
    private final RestTemplateConnectorAutoConfiguration autoConfiguration = new RestTemplateConnectorAutoConfiguration();

    public RestTemplateDictionaryProvider build(DictionaryProviderProperties providerProp, RestTemplateConnectorProperties connectorProp) {
        RestTemplateArtifactService artifactService = this.artifactService(connectorProp);
        DeletableDictionarySnapshotOpener dictionarySnapshotOpener = this.dictionarySnapshotOpener(providerProp, this.categoryRegistryManager(providerProp));
        return new RestTemplateDictionaryProvider(artifactService, providerProp, this.indexFolderProvider(), dictionarySnapshotOpener);
    }

    public RestTemplateDictionaryProvider build(RestTemplateArtifactService artifactService, DictionaryProviderProperties providerProp) {
        DeletableDictionarySnapshotOpener dictionarySnapshotOpener = this.dictionarySnapshotOpener(providerProp, this.categoryRegistryManager(providerProp));
        return new RestTemplateDictionaryProvider(artifactService, providerProp, this.indexFolderProvider(), dictionarySnapshotOpener);
    }

    protected RandomFolderNameProvider randomFolderNameProvider() {
        return new RandomFolderNameProvider();
    }

    protected JarService jarService() {
        return new JarService();
    }

    protected IndexFolderProvider indexFolderProvider() {
        return new IndexFolderProvider();
    }

    public RestTemplateArtifactService artifactService(RestTemplateConnectorProperties connectorProp) {
        RestTemplate restTemplate = this.autoConfiguration.restTemplateFollowRedirect();
        SemanticBundlesApi semanticBundlesApi = this.autoConfiguration.semanticBundlesApi(restTemplate, connectorProp);
        HttpClient httpClient = this.autoConfiguration.httpClient(restTemplate, connectorProp, semanticBundlesApi);
        return new RestTemplateArtifactService(this.jarService(), connectorProp, this.jarProvider(httpClient, connectorProp), this.randomFolderNameProvider(), null);
    }

    protected RestTemplateJarClient jarProvider(HttpClient client, RestTemplateConnectorProperties properties) {
        return new RestTemplateJarClient(client, properties);
    }

    private DeletableDictionarySnapshotOpener dictionarySnapshotOpener(DictionaryProviderProperties properties, CategoryRegistryManager categoryRegistryManager) {
        SemanticProperties semanticProperties = new SemanticProperties(properties.getIndexFolder());
        SharedDictionary sharedDictionary = categoryRegistryManager.getSharedDictionary();
        return new DeletableDictionarySnapshotOpener(semanticProperties, sharedDictionary);
    }

    private CategoryRegistryManager categoryRegistryManager(DictionaryProviderProperties properties) {
        SemanticProperties semanticProperties = new SemanticProperties(properties.getIndexFolder());
        return new CategoryRegistryManager(semanticProperties);
    }
}

