/*
 * Decompiled with CFR 0.152.
 */
package org.talend.tsd.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryFolder
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private boolean deleted = false;
    private final Path path;

    public TemporaryFolder(Path path) {
        this.path = path;
        if (Files.exists(path, new LinkOption[0])) {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new RuntimeException("File already exist and is not a folder" + path);
            }
        } else if (!path.toFile().mkdirs()) {
            throw new RuntimeException("Cannot create temporary folder " + path);
        }
    }

    public Path asPath() {
        if (this.deleted) {
            throw new RuntimeException("Temporary folder " + this.path + " is already deleted");
        }
        return this.path;
    }

    public Path resolve(String other) {
        return this.asPath().resolve(other);
    }

    @Override
    public void close() {
        try {
            this.deleted = true;
            FileUtils.deleteDirectory(this.path.toFile());
        }
        catch (IOException e) {
            this.log.error("Failed to delete jar disk leak", (Throwable)e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemporaryFolder that = (TemporaryFolder)o;
        return Objects.equals(this.log, that.log) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hash(this.log, this.path);
    }

    public String toString() {
        return "TemporaryFolder{path=" + this.path + '}';
    }
}

