/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.aws.clients.swf.flux.metrics;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import software.amazon.aws.clients.swf.flux.metrics.MetricRecorder;

public class InMemoryMetricRecorder
extends MetricRecorder {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, Instant> dates = new HashMap<String, Instant>();
    private final Map<String, Double> counts = new HashMap<String, Double>();
    private final Map<String, Duration> durations = new HashMap<String, Duration>();

    public InMemoryMetricRecorder(String operation) {
        super(operation);
    }

    protected void addPropertyHook(String name, String value) {
        this.properties.put(name, value);
    }

    protected void addTimestampHook(String name, Instant time) {
        this.dates.put(name, time);
    }

    protected void addCountHook(String name, double value) {
        if (!this.counts.containsKey(name)) {
            this.counts.put(name, value);
        } else {
            this.counts.put(name, this.counts.get(name) + value);
        }
    }

    protected void addDurationHook(String name, Duration duration) {
        if (!this.durations.containsKey(name)) {
            this.durations.put(name, duration);
        } else {
            this.durations.put(name, this.durations.get(name).plus(duration));
        }
    }

    public Map<String, Double> getCounts() {
        return this.counts;
    }

    public Map<String, Duration> getDurations() {
        return this.durations;
    }

    public Map<String, Instant> getTimestamps() {
        return this.dates;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

