/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.aws.clients.swf.flux.testutil;

import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import software.amazon.aws.clients.swf.flux.metrics.MetricRecorder;
import software.amazon.aws.clients.swf.flux.metrics.MetricRecorderFactory;
import software.amazon.aws.clients.swf.flux.metrics.NoopMetricRecorderFactory;
import software.amazon.aws.clients.swf.flux.poller.ActivityExecutionUtil;
import software.amazon.aws.clients.swf.flux.step.StepAttributes;
import software.amazon.aws.clients.swf.flux.step.StepResult;
import software.amazon.aws.clients.swf.flux.step.WorkflowStep;

public final class StepValidator {
    private static final MetricRecorderFactory METRICS_FACTORY = new NoopMetricRecorderFactory();

    private StepValidator() {
    }

    public static StepResult completes(WorkflowStep step, Map<String, Object> input, String resultCode) {
        return StepValidator.apply(step, input, resultCode, StepResult.ResultAction.COMPLETE, METRICS_FACTORY.newMetricRecorder(""));
    }

    public static StepResult completes(WorkflowStep step, Map<String, Object> input, String resultCode, MetricRecorder stepMetrics) {
        return StepValidator.apply(step, input, resultCode, StepResult.ResultAction.COMPLETE, stepMetrics);
    }

    public static StepResult succeeds(WorkflowStep step, Map<String, Object> input) {
        return StepValidator.apply(step, input, "_succeed", StepResult.ResultAction.COMPLETE, METRICS_FACTORY.newMetricRecorder(""));
    }

    public static StepResult succeeds(WorkflowStep step, Map<String, Object> input, MetricRecorder stepMetrics) {
        return StepValidator.apply(step, input, "_succeed", StepResult.ResultAction.COMPLETE, stepMetrics);
    }

    public static StepResult fails(WorkflowStep step, Map<String, Object> input) {
        return StepValidator.apply(step, input, "_fail", StepResult.ResultAction.COMPLETE, METRICS_FACTORY.newMetricRecorder(""));
    }

    public static StepResult fails(WorkflowStep step, Map<String, Object> input, MetricRecorder stepMetrics) {
        return StepValidator.apply(step, input, "_fail", StepResult.ResultAction.COMPLETE, stepMetrics);
    }

    public static StepResult retries(WorkflowStep step, Map<String, Object> input) {
        return StepValidator.apply(step, input, null, StepResult.ResultAction.RETRY, METRICS_FACTORY.newMetricRecorder(""));
    }

    public static StepResult retries(WorkflowStep step, Map<String, Object> input, MetricRecorder stepMetrics) {
        return StepValidator.apply(step, input, null, StepResult.ResultAction.RETRY, stepMetrics);
    }

    private static StepResult apply(WorkflowStep step, Map<String, Object> input, String resultCode, StepResult.ResultAction expectedResult, MetricRecorder stepMetrics) {
        HashMap<String, Object> augmentedInput = new HashMap<String, Object>(input);
        augmentedInput.putIfAbsent("_h_workflow_id", "some-workflow-id");
        augmentedInput.putIfAbsent("_execution_id", UUID.randomUUID().toString());
        augmentedInput.putIfAbsent("_workflow_start_time", Date.from(Instant.now()));
        StepResult actual = ActivityExecutionUtil.executeActivity((WorkflowStep)step, (String)step.getClass().getSimpleName(), (MetricRecorder)METRICS_FACTORY.newMetricRecorder(""), (MetricRecorder)stepMetrics, (Map)StepAttributes.serializeMapValues(augmentedInput));
        if (actual.getAction() != expectedResult) {
            throw new RuntimeException(String.format("Expected result action %s but was %s: %s", expectedResult, actual.getAction(), actual.getMessage()), actual.getCause());
        }
        if (resultCode != null && !resultCode.equals(actual.getResultCode())) {
            throw new RuntimeException(String.format("Expected result code %s but was %s", resultCode, actual.getResultCode()));
        }
        return actual;
    }
}

