/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.aws.clients.swf.flux.testutil;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import software.amazon.aws.clients.swf.flux.FluxCapacitor;
import software.amazon.aws.clients.swf.flux.RemoteWorkflowExecutor;
import software.amazon.aws.clients.swf.flux.WorkflowStatusChecker;
import software.amazon.aws.clients.swf.flux.poller.TaskNaming;
import software.amazon.aws.clients.swf.flux.step.StepAttributes;
import software.amazon.aws.clients.swf.flux.testutil.StubRemoteWorkflowExecutor;
import software.amazon.aws.clients.swf.flux.testutil.WorkflowExecutionRecord;
import software.amazon.aws.clients.swf.flux.wf.Workflow;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.swf.SwfClient;

public class StubFluxCapacitor
implements FluxCapacitor {
    private boolean shutdown = false;
    private final Set<Class<? extends Workflow>> workflowTypes = new HashSet<Class<? extends Workflow>>();
    private final Map<WorkflowExecutionRecord, Map<String, Object>> executedWorkflows = new HashMap<WorkflowExecutionRecord, Map<String, Object>>();

    public void initialize(List<Workflow> workflows) {
        if (workflows == null || workflows.isEmpty()) {
            throw new IllegalArgumentException("The specified workflow list must not be empty.");
        }
        for (Workflow workflow : workflows) {
            if (this.workflowTypes.contains(workflow.getClass())) {
                String workflowName = workflow.getClass().getSimpleName();
                String message = "Received more than one Workflow object with the same class name: " + workflowName;
                throw new RuntimeException(message);
            }
            this.workflowTypes.add(workflow.getClass());
        }
    }

    public WorkflowStatusChecker executeWorkflow(Class<? extends Workflow> workflowType, String workflowId, Map<String, Object> workflowInput) {
        if (this.shutdown) {
            throw new RuntimeException("Cannot use the FluxCapacitor after calling shutdown()!");
        }
        if (!this.workflowTypes.contains(workflowType)) {
            throw new RuntimeException("Unrecognized workflow type: " + workflowType.getSimpleName());
        }
        WorkflowExecutionRecord execution = new WorkflowExecutionRecord(workflowType, workflowId);
        if (!this.executedWorkflows.containsKey(execution)) {
            HashMap<String, Object> inputCopy = new HashMap<String, Object>();
            if (workflowInput != null) {
                inputCopy.putAll(workflowInput);
            }
            this.executedWorkflows.put(execution, Collections.unmodifiableMap(inputCopy));
        }
        return new WorkflowStatusChecker(){

            public WorkflowStatusChecker.WorkflowStatus checkStatus() {
                return WorkflowStatusChecker.WorkflowStatus.UNKNOWN;
            }

            public SwfClient getSwfClient() {
                return null;
            }
        };
    }

    public RemoteWorkflowExecutor getRemoteWorkflowExecutor(String swfRegion, String swfEndpoint, AwsCredentialsProvider credentials, String workflowDomain) {
        return new StubRemoteWorkflowExecutor();
    }

    public void verifyWorkflowWasStarted(Class<? extends Workflow> workflowType, String expectedWorkflowId, Map<String, Object> expectedInput) {
        if (!this.workflowTypes.contains(workflowType)) {
            throw new RuntimeException("Unrecognized workflow type: " + workflowType.getSimpleName());
        }
        WorkflowExecutionRecord execution = new WorkflowExecutionRecord(workflowType, expectedWorkflowId);
        if (!this.executedWorkflows.containsKey(execution)) {
            throw new RuntimeException(String.format("No %s execution request for %s was found.", TaskNaming.workflowName(workflowType), expectedWorkflowId));
        }
        if (expectedInput == null && !this.executedWorkflows.get(execution).isEmpty()) {
            throw new RuntimeException(String.format("%s execution %s should have had empty input but instead had %s", TaskNaming.workflowName(workflowType), expectedWorkflowId, StepAttributes.encode(this.executedWorkflows.get(execution))));
        }
        if (!this.executedWorkflows.get(execution).equals(expectedInput)) {
            throw new RuntimeException(String.format("%s execution %s should have had input %s but instead had %s", TaskNaming.workflowName(workflowType), expectedWorkflowId, StepAttributes.encode(expectedInput), StepAttributes.encode(this.executedWorkflows.get(execution))));
        }
    }

    public void verifyWorkflowWasNotStarted(Class<? extends Workflow> workflowType, String workflowId) {
        WorkflowExecutionRecord execution = new WorkflowExecutionRecord(workflowType, workflowId);
        if (this.workflowTypes.contains(workflowType) && this.executedWorkflows.containsKey(execution)) {
            throw new RuntimeException(String.format("%s execution %s should not have been started.", workflowType.getSimpleName(), workflowId));
        }
    }

    public int countExecutedWorkflows() {
        return this.executedWorkflows.size();
    }

    public void resetExecutionCache() {
        this.executedWorkflows.clear();
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return true;
    }
}

