/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.aws.clients.swf.flux.testutil;

import java.util.HashMap;
import java.util.Map;
import software.amazon.aws.clients.swf.flux.RemoteWorkflowExecutor;
import software.amazon.aws.clients.swf.flux.WorkflowStatusChecker;
import software.amazon.aws.clients.swf.flux.poller.TaskNaming;
import software.amazon.aws.clients.swf.flux.step.StepAttributes;
import software.amazon.aws.clients.swf.flux.testutil.WorkflowExecutionRecord;
import software.amazon.aws.clients.swf.flux.wf.Workflow;
import software.amazon.awssdk.services.swf.SwfClient;

public class StubRemoteWorkflowExecutor
implements RemoteWorkflowExecutor {
    private final Map<WorkflowExecutionRecord, Map<String, Object>> executedWorkflows = new HashMap<WorkflowExecutionRecord, Map<String, Object>>();

    public WorkflowStatusChecker executeWorkflow(Class<? extends Workflow> workflowType, String workflowId, Map<String, Object> workflowInput) {
        this.executedWorkflows.put(new WorkflowExecutionRecord(workflowType, workflowId), workflowInput);
        return new WorkflowStatusChecker(){

            public WorkflowStatusChecker.WorkflowStatus checkStatus() {
                return WorkflowStatusChecker.WorkflowStatus.UNKNOWN;
            }

            public SwfClient getSwfClient() {
                return null;
            }
        };
    }

    public void verifyWorkflowWasStarted(Class<? extends Workflow> workflowType, String expectedWorkflowId, Map<String, Object> expectedInput) {
        WorkflowExecutionRecord execution = new WorkflowExecutionRecord(workflowType, expectedWorkflowId);
        if (!this.executedWorkflows.containsKey(execution)) {
            throw new RuntimeException(String.format("No %s execution request for %s was found.", TaskNaming.workflowName(workflowType), expectedWorkflowId));
        }
        if (expectedInput == null && !this.executedWorkflows.get(execution).isEmpty()) {
            throw new RuntimeException(String.format("%s execution %s should have had empty input but instead had %s", TaskNaming.workflowName(workflowType), expectedWorkflowId, StepAttributes.encode(this.executedWorkflows.get(execution))));
        }
        if (!this.executedWorkflows.get(execution).equals(expectedInput)) {
            throw new RuntimeException(String.format("%s execution %s should have had input %s but instead had %s", TaskNaming.workflowName(workflowType), expectedWorkflowId, StepAttributes.encode(expectedInput), StepAttributes.encode(this.executedWorkflows.get(execution))));
        }
    }

    public void verifyWorkflowWasNotStarted(Class<? extends Workflow> workflowType, String workflowId) {
        WorkflowExecutionRecord execution = new WorkflowExecutionRecord(workflowType, workflowId);
        if (this.executedWorkflows.containsKey(execution)) {
            throw new RuntimeException(String.format("%s execution %s should not have been started.", workflowType.getSimpleName(), workflowId));
        }
    }

    public int countExecutedWorkflows() {
        return this.executedWorkflows.size();
    }

    public void resetExecutionCache() {
        this.executedWorkflows.clear();
    }
}

