/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReference;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckInputTextReferenceListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningCheckTranslation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningCheckTranslation> {
    private static final SdkField<List<AutomatedReasoningLogicStatement>> PREMISES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("premises").getter(AutomatedReasoningCheckTranslation.getter(AutomatedReasoningCheckTranslation::premises)).setter(AutomatedReasoningCheckTranslation.setter(Builder::premises)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("premises").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningLogicStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutomatedReasoningLogicStatement>> CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("claims").getter(AutomatedReasoningCheckTranslation.getter(AutomatedReasoningCheckTranslation::claims)).setter(AutomatedReasoningCheckTranslation.setter(Builder::claims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claims").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningLogicStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutomatedReasoningCheckInputTextReference>> UNTRANSLATED_PREMISES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("untranslatedPremises").getter(AutomatedReasoningCheckTranslation.getter(AutomatedReasoningCheckTranslation::untranslatedPremises)).setter(AutomatedReasoningCheckTranslation.setter(Builder::untranslatedPremises)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("untranslatedPremises").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningCheckInputTextReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AutomatedReasoningCheckInputTextReference>> UNTRANSLATED_CLAIMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("untranslatedClaims").getter(AutomatedReasoningCheckTranslation.getter(AutomatedReasoningCheckTranslation::untranslatedClaims)).setter(AutomatedReasoningCheckTranslation.setter(Builder::untranslatedClaims)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("untranslatedClaims").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningCheckInputTextReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> CONFIDENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("confidence").getter(AutomatedReasoningCheckTranslation.getter(AutomatedReasoningCheckTranslation::confidence)).setter(AutomatedReasoningCheckTranslation.setter(Builder::confidence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidence").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREMISES_FIELD, CLAIMS_FIELD, UNTRANSLATED_PREMISES_FIELD, UNTRANSLATED_CLAIMS_FIELD, CONFIDENCE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningCheckTranslation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AutomatedReasoningLogicStatement> premises;
    private final List<AutomatedReasoningLogicStatement> claims;
    private final List<AutomatedReasoningCheckInputTextReference> untranslatedPremises;
    private final List<AutomatedReasoningCheckInputTextReference> untranslatedClaims;
    private final Double confidence;

    private AutomatedReasoningCheckTranslation(BuilderImpl builder) {
        this.premises = builder.premises;
        this.claims = builder.claims;
        this.untranslatedPremises = builder.untranslatedPremises;
        this.untranslatedClaims = builder.untranslatedClaims;
        this.confidence = builder.confidence;
    }

    public final boolean hasPremises() {
        return this.premises != null && !(this.premises instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningLogicStatement> premises() {
        return this.premises;
    }

    public final boolean hasClaims() {
        return this.claims != null && !(this.claims instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningLogicStatement> claims() {
        return this.claims;
    }

    public final boolean hasUntranslatedPremises() {
        return this.untranslatedPremises != null && !(this.untranslatedPremises instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningCheckInputTextReference> untranslatedPremises() {
        return this.untranslatedPremises;
    }

    public final boolean hasUntranslatedClaims() {
        return this.untranslatedClaims != null && !(this.untranslatedClaims instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningCheckInputTextReference> untranslatedClaims() {
        return this.untranslatedClaims;
    }

    public final Double confidence() {
        return this.confidence;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPremises() ? this.premises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClaims() ? this.claims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUntranslatedPremises() ? this.untranslatedPremises() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUntranslatedClaims() ? this.untranslatedClaims() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.confidence());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckTranslation)) {
            return false;
        }
        AutomatedReasoningCheckTranslation other = (AutomatedReasoningCheckTranslation)obj;
        return this.hasPremises() == other.hasPremises() && Objects.equals(this.premises(), other.premises()) && this.hasClaims() == other.hasClaims() && Objects.equals(this.claims(), other.claims()) && this.hasUntranslatedPremises() == other.hasUntranslatedPremises() && Objects.equals(this.untranslatedPremises(), other.untranslatedPremises()) && this.hasUntranslatedClaims() == other.hasUntranslatedClaims() && Objects.equals(this.untranslatedClaims(), other.untranslatedClaims()) && Objects.equals(this.confidence(), other.confidence());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningCheckTranslation").add("Premises", this.hasPremises() ? this.premises() : null).add("Claims", this.hasClaims() ? this.claims() : null).add("UntranslatedPremises", this.hasUntranslatedPremises() ? this.untranslatedPremises() : null).add("UntranslatedClaims", this.hasUntranslatedClaims() ? this.untranslatedClaims() : null).add("Confidence", (Object)this.confidence()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "premises": {
                return Optional.ofNullable(clazz.cast(this.premises()));
            }
            case "claims": {
                return Optional.ofNullable(clazz.cast(this.claims()));
            }
            case "untranslatedPremises": {
                return Optional.ofNullable(clazz.cast(this.untranslatedPremises()));
            }
            case "untranslatedClaims": {
                return Optional.ofNullable(clazz.cast(this.untranslatedClaims()));
            }
            case "confidence": {
                return Optional.ofNullable(clazz.cast(this.confidence()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("premises", PREMISES_FIELD);
        map.put("claims", CLAIMS_FIELD);
        map.put("untranslatedPremises", UNTRANSLATED_PREMISES_FIELD);
        map.put("untranslatedClaims", UNTRANSLATED_CLAIMS_FIELD);
        map.put("confidence", CONFIDENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckTranslation, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckTranslation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AutomatedReasoningLogicStatement> premises = DefaultSdkAutoConstructList.getInstance();
        private List<AutomatedReasoningLogicStatement> claims = DefaultSdkAutoConstructList.getInstance();
        private List<AutomatedReasoningCheckInputTextReference> untranslatedPremises = DefaultSdkAutoConstructList.getInstance();
        private List<AutomatedReasoningCheckInputTextReference> untranslatedClaims = DefaultSdkAutoConstructList.getInstance();
        private Double confidence;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckTranslation model) {
            this.premises(model.premises);
            this.claims(model.claims);
            this.untranslatedPremises(model.untranslatedPremises);
            this.untranslatedClaims(model.untranslatedClaims);
            this.confidence(model.confidence);
        }

        public final List<AutomatedReasoningLogicStatement.Builder> getPremises() {
            List<AutomatedReasoningLogicStatement.Builder> result = AutomatedReasoningLogicStatementListCopier.copyToBuilder(this.premises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPremises(Collection<AutomatedReasoningLogicStatement.BuilderImpl> premises) {
            this.premises = AutomatedReasoningLogicStatementListCopier.copyFromBuilder(premises);
        }

        @Override
        public final Builder premises(Collection<AutomatedReasoningLogicStatement> premises) {
            this.premises = AutomatedReasoningLogicStatementListCopier.copy(premises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(AutomatedReasoningLogicStatement ... premises) {
            this.premises(Arrays.asList(premises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder premises(Consumer<AutomatedReasoningLogicStatement.Builder> ... premises) {
            this.premises(Stream.of(premises).map(c -> (AutomatedReasoningLogicStatement)((AutomatedReasoningLogicStatement.Builder)AutomatedReasoningLogicStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningLogicStatement.Builder> getClaims() {
            List<AutomatedReasoningLogicStatement.Builder> result = AutomatedReasoningLogicStatementListCopier.copyToBuilder(this.claims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClaims(Collection<AutomatedReasoningLogicStatement.BuilderImpl> claims) {
            this.claims = AutomatedReasoningLogicStatementListCopier.copyFromBuilder(claims);
        }

        @Override
        public final Builder claims(Collection<AutomatedReasoningLogicStatement> claims) {
            this.claims = AutomatedReasoningLogicStatementListCopier.copy(claims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(AutomatedReasoningLogicStatement ... claims) {
            this.claims(Arrays.asList(claims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder claims(Consumer<AutomatedReasoningLogicStatement.Builder> ... claims) {
            this.claims(Stream.of(claims).map(c -> (AutomatedReasoningLogicStatement)((AutomatedReasoningLogicStatement.Builder)AutomatedReasoningLogicStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningCheckInputTextReference.Builder> getUntranslatedPremises() {
            List<AutomatedReasoningCheckInputTextReference.Builder> result = AutomatedReasoningCheckInputTextReferenceListCopier.copyToBuilder(this.untranslatedPremises);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUntranslatedPremises(Collection<AutomatedReasoningCheckInputTextReference.BuilderImpl> untranslatedPremises) {
            this.untranslatedPremises = AutomatedReasoningCheckInputTextReferenceListCopier.copyFromBuilder(untranslatedPremises);
        }

        @Override
        public final Builder untranslatedPremises(Collection<AutomatedReasoningCheckInputTextReference> untranslatedPremises) {
            this.untranslatedPremises = AutomatedReasoningCheckInputTextReferenceListCopier.copy(untranslatedPremises);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedPremises(AutomatedReasoningCheckInputTextReference ... untranslatedPremises) {
            this.untranslatedPremises(Arrays.asList(untranslatedPremises));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedPremises(Consumer<AutomatedReasoningCheckInputTextReference.Builder> ... untranslatedPremises) {
            this.untranslatedPremises(Stream.of(untranslatedPremises).map(c -> (AutomatedReasoningCheckInputTextReference)((AutomatedReasoningCheckInputTextReference.Builder)AutomatedReasoningCheckInputTextReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AutomatedReasoningCheckInputTextReference.Builder> getUntranslatedClaims() {
            List<AutomatedReasoningCheckInputTextReference.Builder> result = AutomatedReasoningCheckInputTextReferenceListCopier.copyToBuilder(this.untranslatedClaims);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUntranslatedClaims(Collection<AutomatedReasoningCheckInputTextReference.BuilderImpl> untranslatedClaims) {
            this.untranslatedClaims = AutomatedReasoningCheckInputTextReferenceListCopier.copyFromBuilder(untranslatedClaims);
        }

        @Override
        public final Builder untranslatedClaims(Collection<AutomatedReasoningCheckInputTextReference> untranslatedClaims) {
            this.untranslatedClaims = AutomatedReasoningCheckInputTextReferenceListCopier.copy(untranslatedClaims);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedClaims(AutomatedReasoningCheckInputTextReference ... untranslatedClaims) {
            this.untranslatedClaims(Arrays.asList(untranslatedClaims));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder untranslatedClaims(Consumer<AutomatedReasoningCheckInputTextReference.Builder> ... untranslatedClaims) {
            this.untranslatedClaims(Stream.of(untranslatedClaims).map(c -> (AutomatedReasoningCheckInputTextReference)((AutomatedReasoningCheckInputTextReference.Builder)AutomatedReasoningCheckInputTextReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getConfidence() {
            return this.confidence;
        }

        public final void setConfidence(Double confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Double confidence) {
            this.confidence = confidence;
            return this;
        }

        public AutomatedReasoningCheckTranslation build() {
            return new AutomatedReasoningCheckTranslation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningCheckTranslation> {
        public Builder premises(Collection<AutomatedReasoningLogicStatement> var1);

        public Builder premises(AutomatedReasoningLogicStatement ... var1);

        public Builder premises(Consumer<AutomatedReasoningLogicStatement.Builder> ... var1);

        public Builder claims(Collection<AutomatedReasoningLogicStatement> var1);

        public Builder claims(AutomatedReasoningLogicStatement ... var1);

        public Builder claims(Consumer<AutomatedReasoningLogicStatement.Builder> ... var1);

        public Builder untranslatedPremises(Collection<AutomatedReasoningCheckInputTextReference> var1);

        public Builder untranslatedPremises(AutomatedReasoningCheckInputTextReference ... var1);

        public Builder untranslatedPremises(Consumer<AutomatedReasoningCheckInputTextReference.Builder> ... var1);

        public Builder untranslatedClaims(Collection<AutomatedReasoningCheckInputTextReference> var1);

        public Builder untranslatedClaims(AutomatedReasoningCheckInputTextReference ... var1);

        public Builder untranslatedClaims(Consumer<AutomatedReasoningCheckInputTextReference.Builder> ... var1);

        public Builder confidence(Double var1);
    }
}

