/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.DimensionalPriceRate;
import software.amazon.awssdk.services.bedrock.model.RateCardCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PricingTerm
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PricingTerm> {
    private static final SdkField<List<DimensionalPriceRate>> RATE_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rateCard").getter(PricingTerm.getter(PricingTerm::rateCard)).setter(PricingTerm.setter(Builder::rateCard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateCard").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionalPriceRate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RATE_CARD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PricingTerm.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DimensionalPriceRate> rateCard;

    private PricingTerm(BuilderImpl builder) {
        this.rateCard = builder.rateCard;
    }

    public final boolean hasRateCard() {
        return this.rateCard != null && !(this.rateCard instanceof SdkAutoConstructList);
    }

    public final List<DimensionalPriceRate> rateCard() {
        return this.rateCard;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRateCard() ? this.rateCard() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PricingTerm)) {
            return false;
        }
        PricingTerm other = (PricingTerm)obj;
        return this.hasRateCard() == other.hasRateCard() && Objects.equals(this.rateCard(), other.rateCard());
    }

    public final String toString() {
        return ToString.builder((String)"PricingTerm").add("RateCard", this.hasRateCard() ? this.rateCard() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "rateCard": {
                return Optional.ofNullable(clazz.cast(this.rateCard()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DimensionalPriceRate>>> map = new HashMap<String, SdkField<List<DimensionalPriceRate>>>();
        map.put("rateCard", RATE_CARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PricingTerm, T> g) {
        return obj -> g.apply((PricingTerm)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DimensionalPriceRate> rateCard = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PricingTerm model) {
            this.rateCard(model.rateCard);
        }

        public final List<DimensionalPriceRate.Builder> getRateCard() {
            List<DimensionalPriceRate.Builder> result = RateCardCopier.copyToBuilder(this.rateCard);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRateCard(Collection<DimensionalPriceRate.BuilderImpl> rateCard) {
            this.rateCard = RateCardCopier.copyFromBuilder(rateCard);
        }

        @Override
        public final Builder rateCard(Collection<DimensionalPriceRate> rateCard) {
            this.rateCard = RateCardCopier.copy(rateCard);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(DimensionalPriceRate ... rateCard) {
            this.rateCard(Arrays.asList(rateCard));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(Consumer<DimensionalPriceRate.Builder> ... rateCard) {
            this.rateCard(Stream.of(rateCard).map(c -> (DimensionalPriceRate)((DimensionalPriceRate.Builder)DimensionalPriceRate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PricingTerm build() {
            return new PricingTerm(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PricingTerm> {
        public Builder rateCard(Collection<DimensionalPriceRate> var1);

        public Builder rateCard(DimensionalPriceRate ... var1);

        public Builder rateCard(Consumer<DimensionalPriceRate.Builder> ... var1);
    }
}

