/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.KnowledgeBaseRetrievalConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrieveConfig> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(RetrieveConfig.getter(RetrieveConfig::knowledgeBaseId)).setter(RetrieveConfig.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<KnowledgeBaseRetrievalConfiguration> KNOWLEDGE_BASE_RETRIEVAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseRetrievalConfiguration").getter(RetrieveConfig.getter(RetrieveConfig::knowledgeBaseRetrievalConfiguration)).setter(RetrieveConfig.setter(Builder::knowledgeBaseRetrievalConfiguration)).constructor(KnowledgeBaseRetrievalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseRetrievalConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, KNOWLEDGE_BASE_RETRIEVAL_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrieveConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration;

    private RetrieveConfig(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.knowledgeBaseRetrievalConfiguration = builder.knowledgeBaseRetrievalConfiguration;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration() {
        return this.knowledgeBaseRetrievalConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseRetrievalConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveConfig)) {
            return false;
        }
        RetrieveConfig other = (RetrieveConfig)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.knowledgeBaseRetrievalConfiguration(), other.knowledgeBaseRetrievalConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveConfig").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("KnowledgeBaseRetrievalConfiguration", (Object)this.knowledgeBaseRetrievalConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "knowledgeBaseRetrievalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseRetrievalConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("knowledgeBaseRetrievalConfiguration", KNOWLEDGE_BASE_RETRIEVAL_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveConfig, T> g) {
        return obj -> g.apply((RetrieveConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveConfig model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.knowledgeBaseRetrievalConfiguration(model.knowledgeBaseRetrievalConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getKnowledgeBaseRetrievalConfiguration() {
            return this.knowledgeBaseRetrievalConfiguration != null ? this.knowledgeBaseRetrievalConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.BuilderImpl knowledgeBaseRetrievalConfiguration) {
            this.knowledgeBaseRetrievalConfiguration = knowledgeBaseRetrievalConfiguration != null ? knowledgeBaseRetrievalConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration knowledgeBaseRetrievalConfiguration) {
            this.knowledgeBaseRetrievalConfiguration = knowledgeBaseRetrievalConfiguration;
            return this;
        }

        public RetrieveConfig build() {
            return new RetrieveConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrieveConfig> {
        public Builder knowledgeBaseId(String var1);

        public Builder knowledgeBaseRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration var1);

        default public Builder knowledgeBaseRetrievalConfiguration(Consumer<KnowledgeBaseRetrievalConfiguration.Builder> knowledgeBaseRetrievalConfiguration) {
            return this.knowledgeBaseRetrievalConfiguration((KnowledgeBaseRetrievalConfiguration)((KnowledgeBaseRetrievalConfiguration.Builder)KnowledgeBaseRetrievalConfiguration.builder().applyMutation(knowledgeBaseRetrievalConfiguration)).build());
        }
    }
}

