/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckResult;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAutomatedReasoningPolicyTestCaseRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, UpdateAutomatedReasoningPolicyTestCaseRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyArn").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::policyArn)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()}).build();
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseId").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::testCaseId)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::testCaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("testCaseId").build()}).build();
    private static final SdkField<String> GUARD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardContent").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::guardContent)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::guardContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()}).build();
    private static final SdkField<String> QUERY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryContent").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::queryContent)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::queryContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryContent").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::lastUpdatedAt)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("expectedAggregatedFindingsResult").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::expectedAggregatedFindingsResultAsString)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::expectedAggregatedFindingsResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAggregatedFindingsResult").build()}).build();
    private static final SdkField<Double> CONFIDENCE_THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("confidenceThreshold").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::confidenceThreshold)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::confidenceThreshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(UpdateAutomatedReasoningPolicyTestCaseRequest.getter(UpdateAutomatedReasoningPolicyTestCaseRequest::clientRequestToken)).setter(UpdateAutomatedReasoningPolicyTestCaseRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD, TEST_CASE_ID_FIELD, GUARD_CONTENT_FIELD, QUERY_CONTENT_FIELD, LAST_UPDATED_AT_FIELD, EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD, CONFIDENCE_THRESHOLD_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAutomatedReasoningPolicyTestCaseRequest.memberNameToFieldInitializer();
    private final String policyArn;
    private final String testCaseId;
    private final String guardContent;
    private final String queryContent;
    private final Instant lastUpdatedAt;
    private final String expectedAggregatedFindingsResult;
    private final Double confidenceThreshold;
    private final String clientRequestToken;

    private UpdateAutomatedReasoningPolicyTestCaseRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.testCaseId = builder.testCaseId;
        this.guardContent = builder.guardContent;
        this.queryContent = builder.queryContent;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.expectedAggregatedFindingsResult = builder.expectedAggregatedFindingsResult;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final String testCaseId() {
        return this.testCaseId;
    }

    public final String guardContent() {
        return this.guardContent;
    }

    public final String queryContent() {
        return this.queryContent;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final AutomatedReasoningCheckResult expectedAggregatedFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(this.expectedAggregatedFindingsResult);
    }

    public final String expectedAggregatedFindingsResultAsString() {
        return this.expectedAggregatedFindingsResult;
    }

    public final Double confidenceThreshold() {
        return this.confidenceThreshold;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedAggregatedFindingsResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.confidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyTestCaseRequest)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyTestCaseRequest other = (UpdateAutomatedReasoningPolicyTestCaseRequest)((Object)obj);
        return Objects.equals(this.policyArn(), other.policyArn()) && Objects.equals(this.testCaseId(), other.testCaseId()) && Objects.equals(this.guardContent(), other.guardContent()) && Objects.equals(this.queryContent(), other.queryContent()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.expectedAggregatedFindingsResultAsString(), other.expectedAggregatedFindingsResultAsString()) && Objects.equals(this.confidenceThreshold(), other.confidenceThreshold()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAutomatedReasoningPolicyTestCaseRequest").add("PolicyArn", (Object)this.policyArn()).add("TestCaseId", (Object)this.testCaseId()).add("GuardContent", (Object)(this.guardContent() == null ? null : "*** Sensitive Data Redacted ***")).add("QueryContent", (Object)(this.queryContent() == null ? null : "*** Sensitive Data Redacted ***")).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("ExpectedAggregatedFindingsResult", (Object)this.expectedAggregatedFindingsResultAsString()).add("ConfidenceThreshold", (Object)this.confidenceThreshold()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "testCaseId": {
                return Optional.ofNullable(clazz.cast(this.testCaseId()));
            }
            case "guardContent": {
                return Optional.ofNullable(clazz.cast(this.guardContent()));
            }
            case "queryContent": {
                return Optional.ofNullable(clazz.cast(this.queryContent()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "expectedAggregatedFindingsResult": {
                return Optional.ofNullable(clazz.cast(this.expectedAggregatedFindingsResultAsString()));
            }
            case "confidenceThreshold": {
                return Optional.ofNullable(clazz.cast(this.confidenceThreshold()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("queryContent", QUERY_CONTENT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("expectedAggregatedFindingsResult", EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyTestCaseRequest, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyTestCaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String policyArn;
        private String testCaseId;
        private String guardContent;
        private String queryContent;
        private Instant lastUpdatedAt;
        private String expectedAggregatedFindingsResult;
        private Double confidenceThreshold;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyTestCaseRequest model) {
            super(model);
            this.policyArn(model.policyArn);
            this.testCaseId(model.testCaseId);
            this.guardContent(model.guardContent);
            this.queryContent(model.queryContent);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.expectedAggregatedFindingsResult(model.expectedAggregatedFindingsResult);
            this.confidenceThreshold(model.confidenceThreshold);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getTestCaseId() {
            return this.testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getGuardContent() {
            return this.guardContent;
        }

        public final void setGuardContent(String guardContent) {
            this.guardContent = guardContent;
        }

        @Override
        public final Builder guardContent(String guardContent) {
            this.guardContent = guardContent;
            return this;
        }

        public final String getQueryContent() {
            return this.queryContent;
        }

        public final void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        @Override
        public final Builder queryContent(String queryContent) {
            this.queryContent = queryContent;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getExpectedAggregatedFindingsResult() {
            return this.expectedAggregatedFindingsResult;
        }

        public final void setExpectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
            return this;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult(expectedAggregatedFindingsResult == null ? null : expectedAggregatedFindingsResult.toString());
            return this;
        }

        public final Double getConfidenceThreshold() {
            return this.confidenceThreshold;
        }

        public final void setConfidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyTestCaseRequest build() {
            return new UpdateAutomatedReasoningPolicyTestCaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyTestCaseRequest> {
        public Builder policyArn(String var1);

        public Builder testCaseId(String var1);

        public Builder guardContent(String var1);

        public Builder queryContent(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder expectedAggregatedFindingsResult(String var1);

        public Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult var1);

        public Builder confidenceThreshold(Double var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

