/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyTestResult;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyTestResultsResponse;

public class ListAutomatedReasoningPolicyTestResultsPublisher
implements SdkPublisher<ListAutomatedReasoningPolicyTestResultsResponse> {
    private final BedrockAsyncClient client;
    private final ListAutomatedReasoningPolicyTestResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomatedReasoningPolicyTestResultsPublisher(BedrockAsyncClient client, ListAutomatedReasoningPolicyTestResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomatedReasoningPolicyTestResultsPublisher(BedrockAsyncClient client, ListAutomatedReasoningPolicyTestResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomatedReasoningPolicyTestResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomatedReasoningPolicyTestResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomatedReasoningPolicyTestResult> testResults() {
        Function<ListAutomatedReasoningPolicyTestResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testResults() != null) {
                return response.testResults().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomatedReasoningPolicyTestResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomatedReasoningPolicyTestResultsResponseFetcher
    implements AsyncPageFetcher<ListAutomatedReasoningPolicyTestResultsResponse> {
        private ListAutomatedReasoningPolicyTestResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedReasoningPolicyTestResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomatedReasoningPolicyTestResultsResponse> nextPage(ListAutomatedReasoningPolicyTestResultsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedReasoningPolicyTestResultsPublisher.this.client.listAutomatedReasoningPolicyTestResults(ListAutomatedReasoningPolicyTestResultsPublisher.this.firstRequest);
            }
            return ListAutomatedReasoningPolicyTestResultsPublisher.this.client.listAutomatedReasoningPolicyTestResults((ListAutomatedReasoningPolicyTestResultsRequest)((Object)ListAutomatedReasoningPolicyTestResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

