/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.CustomModelDeploymentSummary;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsResponse;

public class ListCustomModelDeploymentsIterable
implements SdkIterable<ListCustomModelDeploymentsResponse> {
    private final BedrockClient client;
    private final ListCustomModelDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomModelDeploymentsIterable(BedrockClient client, ListCustomModelDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomModelDeploymentsResponseFetcher();
    }

    public Iterator<ListCustomModelDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomModelDeploymentSummary> modelDeploymentSummaries() {
        Function<ListCustomModelDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelDeploymentSummaries() != null) {
                return response.modelDeploymentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomModelDeploymentsResponseFetcher
    implements SyncPageFetcher<ListCustomModelDeploymentsResponse> {
        private ListCustomModelDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomModelDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomModelDeploymentsResponse nextPage(ListCustomModelDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomModelDeploymentsIterable.this.client.listCustomModelDeployments(ListCustomModelDeploymentsIterable.this.firstRequest);
            }
            return ListCustomModelDeploymentsIterable.this.client.listCustomModelDeployments((ListCustomModelDeploymentsRequest)((Object)ListCustomModelDeploymentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

