/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowInputContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FlowInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FlowInput> {
    private static final SdkField<FlowInputContent> CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("content").getter(FlowInput.getter(FlowInput::content)).setter(FlowInput.setter(Builder::content)).constructor(FlowInputContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()}).build();
    private static final SdkField<String> NODE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeName").getter(FlowInput.getter(FlowInput::nodeName)).setter(FlowInput.setter(Builder::nodeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()}).build();
    private static final SdkField<String> NODE_OUTPUT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nodeOutputName").getter(FlowInput.getter(FlowInput::nodeOutputName)).setter(FlowInput.setter(Builder::nodeOutputName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, NODE_NAME_FIELD, NODE_OUTPUT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final FlowInputContent content;
    private final String nodeName;
    private final String nodeOutputName;

    private FlowInput(BuilderImpl builder) {
        this.content = builder.content;
        this.nodeName = builder.nodeName;
        this.nodeOutputName = builder.nodeOutputName;
    }

    public final FlowInputContent content() {
        return this.content;
    }

    public final String nodeName() {
        return this.nodeName;
    }

    public final String nodeOutputName() {
        return this.nodeOutputName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.content());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeOutputName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowInput)) {
            return false;
        }
        FlowInput other = (FlowInput)obj;
        return Objects.equals(this.content(), other.content()) && Objects.equals(this.nodeName(), other.nodeName()) && Objects.equals(this.nodeOutputName(), other.nodeOutputName());
    }

    public final String toString() {
        return ToString.builder((String)"FlowInput").add("Content", (Object)(this.content() == null ? null : "*** Sensitive Data Redacted ***")).add("NodeName", (Object)this.nodeName()).add("NodeOutputName", (Object)this.nodeOutputName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "content": {
                return Optional.ofNullable(clazz.cast(this.content()));
            }
            case "nodeName": {
                return Optional.ofNullable(clazz.cast(this.nodeName()));
            }
            case "nodeOutputName": {
                return Optional.ofNullable(clazz.cast(this.nodeOutputName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowInput, T> g) {
        return obj -> g.apply((FlowInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FlowInputContent content;
        private String nodeName;
        private String nodeOutputName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowInput model) {
            this.content(model.content);
            this.nodeName(model.nodeName);
            this.nodeOutputName(model.nodeOutputName);
        }

        public final FlowInputContent.Builder getContent() {
            return this.content != null ? this.content.toBuilder() : null;
        }

        public final void setContent(FlowInputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowInputContent content) {
            this.content = content;
            return this;
        }

        public final String getNodeName() {
            return this.nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public final String getNodeOutputName() {
            return this.nodeOutputName;
        }

        public final void setNodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
        }

        @Override
        public final Builder nodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
            return this;
        }

        public FlowInput build() {
            return new FlowInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FlowInput> {
        public Builder content(FlowInputContent var1);

        default public Builder content(Consumer<FlowInputContent.Builder> content) {
            return this.content((FlowInputContent)((FlowInputContent.Builder)FlowInputContent.builder().applyMutation(content)).build());
        }

        public Builder nodeName(String var1);

        public Builder nodeOutputName(String var1);
    }
}

