/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuardrailWordPolicyAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailCustomWord
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailCustomWord> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(GuardrailCustomWord.getter(GuardrailCustomWord::actionAsString)).setter(GuardrailCustomWord.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> MATCH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("match").getter(GuardrailCustomWord.getter(GuardrailCustomWord::match)).setter(GuardrailCustomWord.setter(Builder::match)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("match").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MATCH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String match;

    private GuardrailCustomWord(BuilderImpl builder) {
        this.action = builder.action;
        this.match = builder.match;
    }

    public final GuardrailWordPolicyAction action() {
        return GuardrailWordPolicyAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final String match() {
        return this.match;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.match());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailCustomWord)) {
            return false;
        }
        GuardrailCustomWord other = (GuardrailCustomWord)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.match(), other.match());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailCustomWord").add("Action", (Object)this.actionAsString()).add("Match", (Object)this.match()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "match": {
                return Optional.ofNullable(clazz.cast(this.match()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailCustomWord, T> g) {
        return obj -> g.apply((GuardrailCustomWord)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String match;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailCustomWord model) {
            this.action(model.action);
            this.match(model.match);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailWordPolicyAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getMatch() {
            return this.match;
        }

        public final void setMatch(String match) {
            this.match = match;
        }

        @Override
        public final Builder match(String match) {
            this.match = match;
            return this;
        }

        public GuardrailCustomWord build() {
            return new GuardrailCustomWord(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailCustomWord> {
        public Builder action(String var1);

        public Builder action(GuardrailWordPolicyAction var1);

        public Builder match(String var1);
    }
}

