/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetHook;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksCopier;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetHooksStatus;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeChangeSetHooksResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeChangeSetHooksResponse> {
    private static final SdkField<String> CHANGE_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetId").getter(DescribeChangeSetHooksResponse.getter(DescribeChangeSetHooksResponse::changeSetId)).setter(DescribeChangeSetHooksResponse.setter(Builder::changeSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetId").build()}).build();
    private static final SdkField<String> CHANGE_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChangeSetName").getter(DescribeChangeSetHooksResponse.getter(DescribeChangeSetHooksResponse::changeSetName)).setter(DescribeChangeSetHooksResponse.setter(Builder::changeSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeSetName").build()}).build();
    private static final SdkField<List<ChangeSetHook>> HOOKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Hooks").getter(DescribeChangeSetHooksResponse.getter(DescribeChangeSetHooksResponse::hooks)).setter(DescribeChangeSetHooksResponse.setter(Builder::hooks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hooks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ChangeSetHook::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeChangeSetHooksResponse.getter(DescribeChangeSetHooksResponse::statusAsString)).setter(DescribeChangeSetHooksResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeChangeSetHooksResponse.getter(DescribeChangeSetHooksResponse::nextToken)).setter(DescribeChangeSetHooksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(DescribeChangeSetHooksResponse.getter(DescribeChangeSetHooksResponse::stackId)).setter(DescribeChangeSetHooksResponse.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(DescribeChangeSetHooksResponse.getter(DescribeChangeSetHooksResponse::stackName)).setter(DescribeChangeSetHooksResponse.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_SET_ID_FIELD, CHANGE_SET_NAME_FIELD, HOOKS_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD, STACK_ID_FIELD, STACK_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeChangeSetHooksResponse.memberNameToFieldInitializer();
    private final String changeSetId;
    private final String changeSetName;
    private final List<ChangeSetHook> hooks;
    private final String status;
    private final String nextToken;
    private final String stackId;
    private final String stackName;

    private DescribeChangeSetHooksResponse(BuilderImpl builder) {
        super(builder);
        this.changeSetId = builder.changeSetId;
        this.changeSetName = builder.changeSetName;
        this.hooks = builder.hooks;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
    }

    public final String changeSetId() {
        return this.changeSetId;
    }

    public final String changeSetName() {
        return this.changeSetName;
    }

    public final boolean hasHooks() {
        return this.hooks != null && !(this.hooks instanceof SdkAutoConstructList);
    }

    public final List<ChangeSetHook> hooks() {
        return this.hooks;
    }

    public final ChangeSetHooksStatus status() {
        return ChangeSetHooksStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String stackName() {
        return this.stackName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHooks() ? this.hooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeChangeSetHooksResponse)) {
            return false;
        }
        DescribeChangeSetHooksResponse other = (DescribeChangeSetHooksResponse)((Object)obj);
        return Objects.equals(this.changeSetId(), other.changeSetId()) && Objects.equals(this.changeSetName(), other.changeSetName()) && this.hasHooks() == other.hasHooks() && Objects.equals(this.hooks(), other.hooks()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.stackName(), other.stackName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeChangeSetHooksResponse").add("ChangeSetId", (Object)this.changeSetId()).add("ChangeSetName", (Object)this.changeSetName()).add("Hooks", this.hasHooks() ? this.hooks() : null).add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("StackId", (Object)this.stackId()).add("StackName", (Object)this.stackName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChangeSetId": {
                return Optional.ofNullable(clazz.cast(this.changeSetId()));
            }
            case "ChangeSetName": {
                return Optional.ofNullable(clazz.cast(this.changeSetName()));
            }
            case "Hooks": {
                return Optional.ofNullable(clazz.cast(this.hooks()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ChangeSetId", CHANGE_SET_ID_FIELD);
        map.put("ChangeSetName", CHANGE_SET_NAME_FIELD);
        map.put("Hooks", HOOKS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("StackId", STACK_ID_FIELD);
        map.put("StackName", STACK_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeChangeSetHooksResponse, T> g) {
        return obj -> g.apply((DescribeChangeSetHooksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private String changeSetId;
        private String changeSetName;
        private List<ChangeSetHook> hooks = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String nextToken;
        private String stackId;
        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeChangeSetHooksResponse model) {
            super(model);
            this.changeSetId(model.changeSetId);
            this.changeSetName(model.changeSetName);
            this.hooks(model.hooks);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.stackId(model.stackId);
            this.stackName(model.stackName);
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final List<ChangeSetHook.Builder> getHooks() {
            List<ChangeSetHook.Builder> result = ChangeSetHooksCopier.copyToBuilder(this.hooks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHooks(Collection<ChangeSetHook.BuilderImpl> hooks) {
            this.hooks = ChangeSetHooksCopier.copyFromBuilder(hooks);
        }

        @Override
        public final Builder hooks(Collection<ChangeSetHook> hooks) {
            this.hooks = ChangeSetHooksCopier.copy(hooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooks(ChangeSetHook ... hooks) {
            this.hooks(Arrays.asList(hooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hooks(Consumer<ChangeSetHook.Builder> ... hooks) {
            this.hooks(Stream.of(hooks).map(c -> (ChangeSetHook)((ChangeSetHook.Builder)ChangeSetHook.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ChangeSetHooksStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStackName() {
            return this.stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        @Override
        public DescribeChangeSetHooksResponse build() {
            return new DescribeChangeSetHooksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeChangeSetHooksResponse> {
        public Builder changeSetId(String var1);

        public Builder changeSetName(String var1);

        public Builder hooks(Collection<ChangeSetHook> var1);

        public Builder hooks(ChangeSetHook ... var1);

        public Builder hooks(Consumer<ChangeSetHook.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(ChangeSetHooksStatus var1);

        public Builder nextToken(String var1);

        public Builder stackId(String var1);

        public Builder stackName(String var1);
    }
}

