/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.StacksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeStacksResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, DescribeStacksResponse> {
    private static final SdkField<List<Stack>> STACKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Stacks").getter(DescribeStacksResponse.getter(DescribeStacksResponse::stacks)).setter(DescribeStacksResponse.setter(Builder::stacks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stacks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Stack::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeStacksResponse.getter(DescribeStacksResponse::nextToken)).setter(DescribeStacksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeStacksResponse.memberNameToFieldInitializer();
    private final List<Stack> stacks;
    private final String nextToken;

    private DescribeStacksResponse(BuilderImpl builder) {
        super(builder);
        this.stacks = builder.stacks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasStacks() {
        return this.stacks != null && !(this.stacks instanceof SdkAutoConstructList);
    }

    public final List<Stack> stacks() {
        return this.stacks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStacks() ? this.stacks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse)((Object)obj);
        return this.hasStacks() == other.hasStacks() && Objects.equals(this.stacks(), other.stacks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeStacksResponse").add("Stacks", this.hasStacks() ? this.stacks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Stacks": {
                return Optional.ofNullable(clazz.cast(this.stacks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Stacks", STACKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeStacksResponse, T> g) {
        return obj -> g.apply((DescribeStacksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<Stack> stacks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            super(model);
            this.stacks(model.stacks);
            this.nextToken(model.nextToken);
        }

        public final List<Stack.Builder> getStacks() {
            List<Stack.Builder> result = StacksCopier.copyToBuilder(this.stacks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStacks(Collection<Stack.BuilderImpl> stacks) {
            this.stacks = StacksCopier.copyFromBuilder(stacks);
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack ... stacks) {
            this.stacks(Arrays.asList(stacks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Consumer<Stack.Builder> ... stacks) {
            this.stacks(Stream.of(stacks).map(c -> (Stack)((Stack.Builder)Stack.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeStacksResponse> {
        public Builder stacks(Collection<Stack> var1);

        public Builder stacks(Stack ... var1);

        public Builder stacks(Consumer<Stack.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

