/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.DeprecatedStatus;
import software.amazon.awssdk.services.cloudformation.model.RegistryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTypeVersionsRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, ListTypeVersionsRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ListTypeVersionsRequest.getter(ListTypeVersionsRequest::typeAsString)).setter(ListTypeVersionsRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeName").getter(ListTypeVersionsRequest.getter(ListTypeVersionsRequest::typeName)).setter(ListTypeVersionsRequest.setter(Builder::typeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ListTypeVersionsRequest.getter(ListTypeVersionsRequest::arn)).setter(ListTypeVersionsRequest.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTypeVersionsRequest.getter(ListTypeVersionsRequest::maxResults)).setter(ListTypeVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTypeVersionsRequest.getter(ListTypeVersionsRequest::nextToken)).setter(ListTypeVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> DEPRECATED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeprecatedStatus").getter(ListTypeVersionsRequest.getter(ListTypeVersionsRequest::deprecatedStatusAsString)).setter(ListTypeVersionsRequest.setter(Builder::deprecatedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecatedStatus").build()}).build();
    private static final SdkField<String> PUBLISHER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublisherId").getter(ListTypeVersionsRequest.getter(ListTypeVersionsRequest::publisherId)).setter(ListTypeVersionsRequest.setter(Builder::publisherId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublisherId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TYPE_NAME_FIELD, ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, DEPRECATED_STATUS_FIELD, PUBLISHER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTypeVersionsRequest.memberNameToFieldInitializer();
    private final String type;
    private final String typeName;
    private final String arn;
    private final Integer maxResults;
    private final String nextToken;
    private final String deprecatedStatus;
    private final String publisherId;

    private ListTypeVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.typeName = builder.typeName;
        this.arn = builder.arn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.deprecatedStatus = builder.deprecatedStatus;
        this.publisherId = builder.publisherId;
    }

    public final RegistryType type() {
        return RegistryType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String typeName() {
        return this.typeName;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final DeprecatedStatus deprecatedStatus() {
        return DeprecatedStatus.fromValue(this.deprecatedStatus);
    }

    public final String deprecatedStatusAsString() {
        return this.deprecatedStatus;
    }

    public final String publisherId() {
        return this.publisherId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecatedStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.publisherId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypeVersionsRequest)) {
            return false;
        }
        ListTypeVersionsRequest other = (ListTypeVersionsRequest)((Object)obj);
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.typeName(), other.typeName()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.deprecatedStatusAsString(), other.deprecatedStatusAsString()) && Objects.equals(this.publisherId(), other.publisherId());
    }

    public final String toString() {
        return ToString.builder((String)"ListTypeVersionsRequest").add("Type", (Object)this.typeAsString()).add("TypeName", (Object)this.typeName()).add("Arn", (Object)this.arn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("DeprecatedStatus", (Object)this.deprecatedStatusAsString()).add("PublisherId", (Object)this.publisherId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "TypeName": {
                return Optional.ofNullable(clazz.cast(this.typeName()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "DeprecatedStatus": {
                return Optional.ofNullable(clazz.cast(this.deprecatedStatusAsString()));
            }
            case "PublisherId": {
                return Optional.ofNullable(clazz.cast(this.publisherId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("TypeName", TYPE_NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DeprecatedStatus", DEPRECATED_STATUS_FIELD);
        map.put("PublisherId", PUBLISHER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTypeVersionsRequest, T> g) {
        return obj -> g.apply((ListTypeVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String type;
        private String typeName;
        private String arn;
        private Integer maxResults;
        private String nextToken;
        private String deprecatedStatus;
        private String publisherId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypeVersionsRequest model) {
            super(model);
            this.type(model.type);
            this.typeName(model.typeName);
            this.arn(model.arn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.deprecatedStatus(model.deprecatedStatus);
            this.publisherId(model.publisherId);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RegistryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTypeName() {
            return this.typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDeprecatedStatus() {
            return this.deprecatedStatus;
        }

        public final void setDeprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
        }

        @Override
        public final Builder deprecatedStatus(String deprecatedStatus) {
            this.deprecatedStatus = deprecatedStatus;
            return this;
        }

        @Override
        public final Builder deprecatedStatus(DeprecatedStatus deprecatedStatus) {
            this.deprecatedStatus(deprecatedStatus == null ? null : deprecatedStatus.toString());
            return this;
        }

        public final String getPublisherId() {
            return this.publisherId;
        }

        public final void setPublisherId(String publisherId) {
            this.publisherId = publisherId;
        }

        @Override
        public final Builder publisherId(String publisherId) {
            this.publisherId = publisherId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTypeVersionsRequest build() {
            return new ListTypeVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTypeVersionsRequest> {
        public Builder type(String var1);

        public Builder type(RegistryType var1);

        public Builder typeName(String var1);

        public Builder arn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder deprecatedStatus(String var1);

        public Builder deprecatedStatus(DeprecatedStatus var1);

        public Builder publisherId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

