/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.ResourceScanStatus;
import software.amazon.awssdk.services.cloudformation.model.ScanType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceScanSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceScanSummary> {
    private static final SdkField<String> RESOURCE_SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceScanId").getter(ResourceScanSummary.getter(ResourceScanSummary::resourceScanId)).setter(ResourceScanSummary.setter(Builder::resourceScanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceScanId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResourceScanSummary.getter(ResourceScanSummary::statusAsString)).setter(ResourceScanSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(ResourceScanSummary.getter(ResourceScanSummary::statusReason)).setter(ResourceScanSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ResourceScanSummary.getter(ResourceScanSummary::startTime)).setter(ResourceScanSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ResourceScanSummary.getter(ResourceScanSummary::endTime)).setter(ResourceScanSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Double> PERCENTAGE_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("PercentageCompleted").getter(ResourceScanSummary.getter(ResourceScanSummary::percentageCompleted)).setter(ResourceScanSummary.setter(Builder::percentageCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentageCompleted").build()}).build();
    private static final SdkField<String> SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanType").getter(ResourceScanSummary.getter(ResourceScanSummary::scanTypeAsString)).setter(ResourceScanSummary.setter(Builder::scanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_SCAN_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERCENTAGE_COMPLETED_FIELD, SCAN_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceScanSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String resourceScanId;
    private final String status;
    private final String statusReason;
    private final Instant startTime;
    private final Instant endTime;
    private final Double percentageCompleted;
    private final String scanType;

    private ResourceScanSummary(BuilderImpl builder) {
        this.resourceScanId = builder.resourceScanId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.percentageCompleted = builder.percentageCompleted;
        this.scanType = builder.scanType;
    }

    public final String resourceScanId() {
        return this.resourceScanId;
    }

    public final ResourceScanStatus status() {
        return ResourceScanStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Double percentageCompleted() {
        return this.percentageCompleted;
    }

    public final ScanType scanType() {
        return ScanType.fromValue(this.scanType);
    }

    public final String scanTypeAsString() {
        return this.scanType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceScanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentageCompleted());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceScanSummary)) {
            return false;
        }
        ResourceScanSummary other = (ResourceScanSummary)obj;
        return Objects.equals(this.resourceScanId(), other.resourceScanId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.percentageCompleted(), other.percentageCompleted()) && Objects.equals(this.scanTypeAsString(), other.scanTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceScanSummary").add("ResourceScanId", (Object)this.resourceScanId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("PercentageCompleted", (Object)this.percentageCompleted()).add("ScanType", (Object)this.scanTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceScanId": {
                return Optional.ofNullable(clazz.cast(this.resourceScanId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "PercentageCompleted": {
                return Optional.ofNullable(clazz.cast(this.percentageCompleted()));
            }
            case "ScanType": {
                return Optional.ofNullable(clazz.cast(this.scanTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ResourceScanId", RESOURCE_SCAN_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("PercentageCompleted", PERCENTAGE_COMPLETED_FIELD);
        map.put("ScanType", SCAN_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceScanSummary, T> g) {
        return obj -> g.apply((ResourceScanSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resourceScanId;
        private String status;
        private String statusReason;
        private Instant startTime;
        private Instant endTime;
        private Double percentageCompleted;
        private String scanType;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceScanSummary model) {
            this.resourceScanId(model.resourceScanId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.percentageCompleted(model.percentageCompleted);
            this.scanType(model.scanType);
        }

        public final String getResourceScanId() {
            return this.resourceScanId;
        }

        public final void setResourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
        }

        @Override
        public final Builder resourceScanId(String resourceScanId) {
            this.resourceScanId = resourceScanId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceScanStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Double getPercentageCompleted() {
            return this.percentageCompleted;
        }

        public final void setPercentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
        }

        @Override
        public final Builder percentageCompleted(Double percentageCompleted) {
            this.percentageCompleted = percentageCompleted;
            return this;
        }

        public final String getScanType() {
            return this.scanType;
        }

        public final void setScanType(String scanType) {
            this.scanType = scanType;
        }

        @Override
        public final Builder scanType(String scanType) {
            this.scanType = scanType;
            return this;
        }

        @Override
        public final Builder scanType(ScanType scanType) {
            this.scanType(scanType == null ? null : scanType.toString());
            return this;
        }

        public ResourceScanSummary build() {
            return new ResourceScanSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceScanSummary> {
        public Builder resourceScanId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceScanStatus var1);

        public Builder statusReason(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder percentageCompleted(Double var1);

        public Builder scanType(String var1);

        public Builder scanType(ScanType var1);
    }
}

