/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerExecutionFailure;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerExecutionFailureListCopier;
import software.amazon.awssdk.services.codecommit.model.RepositoryTriggerNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestRepositoryTriggersResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, TestRepositoryTriggersResponse> {
    private static final SdkField<List<String>> SUCCESSFUL_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successfulExecutions").getter(TestRepositoryTriggersResponse.getter(TestRepositoryTriggersResponse::successfulExecutions)).setter(TestRepositoryTriggersResponse.setter(Builder::successfulExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successfulExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RepositoryTriggerExecutionFailure>> FAILED_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failedExecutions").getter(TestRepositoryTriggersResponse.getter(TestRepositoryTriggersResponse::failedExecutions)).setter(TestRepositoryTriggersResponse.setter(Builder::failedExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failedExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RepositoryTriggerExecutionFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_EXECUTIONS_FIELD, FAILED_EXECUTIONS_FIELD));
    private final List<String> successfulExecutions;
    private final List<RepositoryTriggerExecutionFailure> failedExecutions;

    private TestRepositoryTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.successfulExecutions = builder.successfulExecutions;
        this.failedExecutions = builder.failedExecutions;
    }

    public final boolean hasSuccessfulExecutions() {
        return this.successfulExecutions != null && !(this.successfulExecutions instanceof SdkAutoConstructList);
    }

    public final List<String> successfulExecutions() {
        return this.successfulExecutions;
    }

    public final boolean hasFailedExecutions() {
        return this.failedExecutions != null && !(this.failedExecutions instanceof SdkAutoConstructList);
    }

    public final List<RepositoryTriggerExecutionFailure> failedExecutions() {
        return this.failedExecutions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulExecutions() ? this.successfulExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedExecutions() ? this.failedExecutions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRepositoryTriggersResponse)) {
            return false;
        }
        TestRepositoryTriggersResponse other = (TestRepositoryTriggersResponse)((Object)obj);
        return this.hasSuccessfulExecutions() == other.hasSuccessfulExecutions() && Objects.equals(this.successfulExecutions(), other.successfulExecutions()) && this.hasFailedExecutions() == other.hasFailedExecutions() && Objects.equals(this.failedExecutions(), other.failedExecutions());
    }

    public final String toString() {
        return ToString.builder((String)"TestRepositoryTriggersResponse").add("SuccessfulExecutions", this.hasSuccessfulExecutions() ? this.successfulExecutions() : null).add("FailedExecutions", this.hasFailedExecutions() ? this.failedExecutions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "successfulExecutions": {
                return Optional.ofNullable(clazz.cast(this.successfulExecutions()));
            }
            case "failedExecutions": {
                return Optional.ofNullable(clazz.cast(this.failedExecutions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestRepositoryTriggersResponse, T> g) {
        return obj -> g.apply((TestRepositoryTriggersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<String> successfulExecutions = DefaultSdkAutoConstructList.getInstance();
        private List<RepositoryTriggerExecutionFailure> failedExecutions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TestRepositoryTriggersResponse model) {
            super(model);
            this.successfulExecutions(model.successfulExecutions);
            this.failedExecutions(model.failedExecutions);
        }

        public final Collection<String> getSuccessfulExecutions() {
            if (this.successfulExecutions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successfulExecutions;
        }

        @Override
        public final Builder successfulExecutions(Collection<String> successfulExecutions) {
            this.successfulExecutions = RepositoryTriggerNameListCopier.copy(successfulExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulExecutions(String ... successfulExecutions) {
            this.successfulExecutions(Arrays.asList(successfulExecutions));
            return this;
        }

        public final void setSuccessfulExecutions(Collection<String> successfulExecutions) {
            this.successfulExecutions = RepositoryTriggerNameListCopier.copy(successfulExecutions);
        }

        public final Collection<RepositoryTriggerExecutionFailure.Builder> getFailedExecutions() {
            if (this.failedExecutions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failedExecutions != null ? (Collection)this.failedExecutions.stream().map(RepositoryTriggerExecutionFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedExecutions(Collection<RepositoryTriggerExecutionFailure> failedExecutions) {
            this.failedExecutions = RepositoryTriggerExecutionFailureListCopier.copy(failedExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedExecutions(RepositoryTriggerExecutionFailure ... failedExecutions) {
            this.failedExecutions(Arrays.asList(failedExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedExecutions(Consumer<RepositoryTriggerExecutionFailure.Builder> ... failedExecutions) {
            this.failedExecutions(Stream.of(failedExecutions).map(c -> (RepositoryTriggerExecutionFailure)((RepositoryTriggerExecutionFailure.Builder)RepositoryTriggerExecutionFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedExecutions(Collection<RepositoryTriggerExecutionFailure.BuilderImpl> failedExecutions) {
            this.failedExecutions = RepositoryTriggerExecutionFailureListCopier.copyFromBuilder(failedExecutions);
        }

        @Override
        public TestRepositoryTriggersResponse build() {
            return new TestRepositoryTriggersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, TestRepositoryTriggersResponse> {
        public Builder successfulExecutions(Collection<String> var1);

        public Builder successfulExecutions(String ... var1);

        public Builder failedExecutions(Collection<RepositoryTriggerExecutionFailure> var1);

        public Builder failedExecutions(RepositoryTriggerExecutionFailure ... var1);

        public Builder failedExecutions(Consumer<RepositoryTriggerExecutionFailure.Builder> ... var1);
    }
}

