/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitClient;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitRequest;
import software.amazon.awssdk.services.codecommit.model.GetCommentsForComparedCommitResponse;

public class GetCommentsForComparedCommitIterable
implements SdkIterable<GetCommentsForComparedCommitResponse> {
    private final CodeCommitClient client;
    private final GetCommentsForComparedCommitRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetCommentsForComparedCommitIterable(CodeCommitClient client, GetCommentsForComparedCommitRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetCommentsForComparedCommitResponseFetcher();
    }

    public Iterator<GetCommentsForComparedCommitResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetCommentsForComparedCommitResponseFetcher
    implements SyncPageFetcher<GetCommentsForComparedCommitResponse> {
        private GetCommentsForComparedCommitResponseFetcher() {
        }

        public boolean hasNextPage(GetCommentsForComparedCommitResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetCommentsForComparedCommitResponse nextPage(GetCommentsForComparedCommitResponse previousPage) {
            if (previousPage == null) {
                return GetCommentsForComparedCommitIterable.this.client.getCommentsForComparedCommit(GetCommentsForComparedCommitIterable.this.firstRequest);
            }
            return GetCommentsForComparedCommitIterable.this.client.getCommentsForComparedCommit((GetCommentsForComparedCommitRequest)((Object)GetCommentsForComparedCommitIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

