/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codegurureviewer.CodeGuruReviewerAsyncClient;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.codegurureviewer.model.ListRecommendationsResponse;

public class ListRecommendationsPublisher
implements SdkPublisher<ListRecommendationsResponse> {
    private final CodeGuruReviewerAsyncClient client;
    private final ListRecommendationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendationsPublisher(CodeGuruReviewerAsyncClient client, ListRecommendationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendationsPublisher(CodeGuruReviewerAsyncClient client, ListRecommendationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListRecommendationsResponseFetcher
    implements AsyncPageFetcher<ListRecommendationsResponse> {
        private ListRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendationsResponse> nextPage(ListRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationsPublisher.this.client.listRecommendations(ListRecommendationsPublisher.this.firstRequest);
            }
            return ListRecommendationsPublisher.this.client.listRecommendations((ListRecommendationsRequest)((Object)ListRecommendationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

