/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AuthFlowType {
    USER_SRP_AUTH("USER_SRP_AUTH"),
    REFRESH_TOKEN_AUTH("REFRESH_TOKEN_AUTH"),
    REFRESH_TOKEN("REFRESH_TOKEN"),
    CUSTOM_AUTH("CUSTOM_AUTH"),
    ADMIN_NO_SRP_AUTH("ADMIN_NO_SRP_AUTH"),
    USER_PASSWORD_AUTH("USER_PASSWORD_AUTH"),
    ADMIN_USER_PASSWORD_AUTH("ADMIN_USER_PASSWORD_AUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AuthFlowType> VALUE_MAP;
    private final String value;

    private AuthFlowType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AuthFlowType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AuthFlowType> knownValues() {
        EnumSet<AuthFlowType> knownValues = EnumSet.allOf(AuthFlowType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AuthFlowType.class, AuthFlowType::toString);
    }
}

