/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.EnvironmentError;
import software.amazon.awssdk.services.datazone.model.EnvironmentFailureReasonsCopier;
import software.amazon.awssdk.services.datazone.model.OverallDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentDeploymentDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentDeploymentDetails> {
    private static final SdkField<Map<String, List<EnvironmentError>>> ENVIRONMENT_FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentFailureReasons").getter(EnvironmentDeploymentDetails.getter(EnvironmentDeploymentDetails::environmentFailureReasons)).setter(EnvironmentDeploymentDetails.setter(Builder::environmentFailureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentFailureReasons").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> OVERALL_DEPLOYMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overallDeploymentStatus").getter(EnvironmentDeploymentDetails.getter(EnvironmentDeploymentDetails::overallDeploymentStatusAsString)).setter(EnvironmentDeploymentDetails.setter(Builder::overallDeploymentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overallDeploymentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_FAILURE_REASONS_FIELD, OVERALL_DEPLOYMENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentDeploymentDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, List<EnvironmentError>> environmentFailureReasons;
    private final String overallDeploymentStatus;

    private EnvironmentDeploymentDetails(BuilderImpl builder) {
        this.environmentFailureReasons = builder.environmentFailureReasons;
        this.overallDeploymentStatus = builder.overallDeploymentStatus;
    }

    public final boolean hasEnvironmentFailureReasons() {
        return this.environmentFailureReasons != null && !(this.environmentFailureReasons instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<EnvironmentError>> environmentFailureReasons() {
        return this.environmentFailureReasons;
    }

    public final OverallDeploymentStatus overallDeploymentStatus() {
        return OverallDeploymentStatus.fromValue(this.overallDeploymentStatus);
    }

    public final String overallDeploymentStatusAsString() {
        return this.overallDeploymentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentFailureReasons() ? this.environmentFailureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.overallDeploymentStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentDeploymentDetails)) {
            return false;
        }
        EnvironmentDeploymentDetails other = (EnvironmentDeploymentDetails)obj;
        return this.hasEnvironmentFailureReasons() == other.hasEnvironmentFailureReasons() && Objects.equals(this.environmentFailureReasons(), other.environmentFailureReasons()) && Objects.equals(this.overallDeploymentStatusAsString(), other.overallDeploymentStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentDeploymentDetails").add("EnvironmentFailureReasons", this.hasEnvironmentFailureReasons() ? this.environmentFailureReasons() : null).add("OverallDeploymentStatus", (Object)this.overallDeploymentStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentFailureReasons": {
                return Optional.ofNullable(clazz.cast(this.environmentFailureReasons()));
            }
            case "overallDeploymentStatus": {
                return Optional.ofNullable(clazz.cast(this.overallDeploymentStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("environmentFailureReasons", ENVIRONMENT_FAILURE_REASONS_FIELD);
        map.put("overallDeploymentStatus", OVERALL_DEPLOYMENT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentDeploymentDetails, T> g) {
        return obj -> g.apply((EnvironmentDeploymentDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, List<EnvironmentError>> environmentFailureReasons = DefaultSdkAutoConstructMap.getInstance();
        private String overallDeploymentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentDeploymentDetails model) {
            this.environmentFailureReasons(model.environmentFailureReasons);
            this.overallDeploymentStatus(model.overallDeploymentStatus);
        }

        public final Map<String, List<EnvironmentError.Builder>> getEnvironmentFailureReasons() {
            Map<String, List<EnvironmentError.Builder>> result = EnvironmentFailureReasonsCopier.copyToBuilder(this.environmentFailureReasons);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentFailureReasons(Map<String, ? extends Collection<EnvironmentError.BuilderImpl>> environmentFailureReasons) {
            this.environmentFailureReasons = EnvironmentFailureReasonsCopier.copyFromBuilder(environmentFailureReasons);
        }

        @Override
        public final Builder environmentFailureReasons(Map<String, ? extends Collection<EnvironmentError>> environmentFailureReasons) {
            this.environmentFailureReasons = EnvironmentFailureReasonsCopier.copy(environmentFailureReasons);
            return this;
        }

        public final String getOverallDeploymentStatus() {
            return this.overallDeploymentStatus;
        }

        public final void setOverallDeploymentStatus(String overallDeploymentStatus) {
            this.overallDeploymentStatus = overallDeploymentStatus;
        }

        @Override
        public final Builder overallDeploymentStatus(String overallDeploymentStatus) {
            this.overallDeploymentStatus = overallDeploymentStatus;
            return this;
        }

        @Override
        public final Builder overallDeploymentStatus(OverallDeploymentStatus overallDeploymentStatus) {
            this.overallDeploymentStatus(overallDeploymentStatus == null ? null : overallDeploymentStatus.toString());
            return this;
        }

        public EnvironmentDeploymentDetails build() {
            return new EnvironmentDeploymentDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentDeploymentDetails> {
        public Builder environmentFailureReasons(Map<String, ? extends Collection<EnvironmentError>> var1);

        public Builder overallDeploymentStatus(String var1);

        public Builder overallDeploymentStatus(OverallDeploymentStatus var1);
    }
}

