/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.internal.mapper;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.enhanced.dynamodb.internal.mapper.MetaTableSchema;

@SdkInternalApi
public class MetaTableSchemaCache {
    private final Map<Class<?>, MetaTableSchema<?>> cacheMap = new HashMap();

    public <T> MetaTableSchema<T> getOrCreate(Class<T> mappedClass) {
        return this.cacheMap().computeIfAbsent(mappedClass, ignored -> MetaTableSchema.create(mappedClass));
    }

    public <T> Optional<MetaTableSchema<T>> get(Class<T> mappedClass) {
        return Optional.ofNullable(this.cacheMap().get(mappedClass));
    }

    private Map<Class<?>, MetaTableSchema<?>> cacheMap() {
        return this.cacheMap;
    }
}

