/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.enhanced.dynamodb.update;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.enhanced.dynamodb.update.UpdateAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class DeleteAction
implements UpdateAction,
ToCopyableBuilder<Builder, DeleteAction> {
    private final String path;
    private final String value;
    private final Map<String, String> expressionNames;
    private final Map<String, AttributeValue> expressionValues;

    private DeleteAction(Builder builder) {
        this.path = (String)Validate.paramNotNull((Object)builder.path, (String)"path");
        this.value = (String)Validate.paramNotNull((Object)builder.value, (String)"value");
        this.expressionValues = DeleteAction.wrapSecure((Map)Validate.paramNotNull((Object)builder.expressionValues, (String)"expressionValues"));
        this.expressionNames = DeleteAction.wrapSecure(builder.expressionNames != null ? builder.expressionNames : new HashMap());
    }

    private static <T, U> Map<T, U> wrapSecure(Map<T, U> map) {
        return Collections.unmodifiableMap(new HashMap<T, U>(map));
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return DeleteAction.builder().path(this.path).value(this.value).expressionNames(this.expressionNames).expressionValues(this.expressionValues);
    }

    public String path() {
        return this.path;
    }

    public String value() {
        return this.value;
    }

    public Map<String, String> expressionNames() {
        return this.expressionNames;
    }

    public Map<String, AttributeValue> expressionValues() {
        return this.expressionValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteAction that = (DeleteAction)o;
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.expressionValues != null ? !this.expressionValues.equals(that.expressionValues) : that.expressionValues != null) {
            return false;
        }
        return this.expressionNames != null ? this.expressionNames.equals(that.expressionNames) : that.expressionNames == null;
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.expressionValues != null ? this.expressionValues.hashCode() : 0);
        result = 31 * result + (this.expressionNames != null ? this.expressionNames.hashCode() : 0);
        return result;
    }

    public static final class Builder
    implements CopyableBuilder<Builder, DeleteAction> {
        private String path;
        private String value;
        private Map<String, String> expressionNames;
        private Map<String, AttributeValue> expressionValues;

        private Builder() {
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder expressionValues(Map<String, AttributeValue> expressionValues) {
            this.expressionValues = expressionValues == null ? null : new HashMap<String, AttributeValue>(expressionValues);
            return this;
        }

        public Builder putExpressionValue(String key, AttributeValue value) {
            if (this.expressionValues == null) {
                this.expressionValues = new HashMap<String, AttributeValue>();
            }
            this.expressionValues.put(key, value);
            return this;
        }

        public Builder expressionNames(Map<String, String> expressionNames) {
            this.expressionNames = expressionNames == null ? null : new HashMap<String, String>(expressionNames);
            return this;
        }

        public Builder putExpressionName(String key, String value) {
            if (this.expressionNames == null) {
                this.expressionNames = new HashMap<String, String>();
            }
            this.expressionNames.put(key, value);
            return this;
        }

        public DeleteAction build() {
            return new DeleteAction(this);
        }
    }
}

