/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceLifecycle {
    SPOT("spot"),
    ON_DEMAND("on-demand"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceLifecycle> VALUE_MAP;
    private final String value;

    private InstanceLifecycle(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceLifecycle fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceLifecycle> knownValues() {
        EnumSet<InstanceLifecycle> knownValues = EnumSet.allOf(InstanceLifecycle.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceLifecycle.class, InstanceLifecycle::toString);
    }
}

