/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecrpublic.model.ArchitectureListCopier;
import software.amazon.awssdk.services.ecrpublic.model.OperatingSystemListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryCatalogData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryCatalogData> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(RepositoryCatalogData.getter(RepositoryCatalogData::description)).setter(RepositoryCatalogData.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> ARCHITECTURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("architectures").getter(RepositoryCatalogData.getter(RepositoryCatalogData::architectures)).setter(RepositoryCatalogData.setter(Builder::architectures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("architectures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OPERATING_SYSTEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("operatingSystems").getter(RepositoryCatalogData.getter(RepositoryCatalogData::operatingSystems)).setter(RepositoryCatalogData.setter(Builder::operatingSystems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operatingSystems").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LOGO_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logoUrl").getter(RepositoryCatalogData.getter(RepositoryCatalogData::logoUrl)).setter(RepositoryCatalogData.setter(Builder::logoUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logoUrl").build()}).build();
    private static final SdkField<String> ABOUT_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aboutText").getter(RepositoryCatalogData.getter(RepositoryCatalogData::aboutText)).setter(RepositoryCatalogData.setter(Builder::aboutText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aboutText").build()}).build();
    private static final SdkField<String> USAGE_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageText").getter(RepositoryCatalogData.getter(RepositoryCatalogData::usageText)).setter(RepositoryCatalogData.setter(Builder::usageText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageText").build()}).build();
    private static final SdkField<Boolean> MARKETPLACE_CERTIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("marketplaceCertified").getter(RepositoryCatalogData.getter(RepositoryCatalogData::marketplaceCertified)).setter(RepositoryCatalogData.setter(Builder::marketplaceCertified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("marketplaceCertified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, ARCHITECTURES_FIELD, OPERATING_SYSTEMS_FIELD, LOGO_URL_FIELD, ABOUT_TEXT_FIELD, USAGE_TEXT_FIELD, MARKETPLACE_CERTIFIED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final List<String> architectures;
    private final List<String> operatingSystems;
    private final String logoUrl;
    private final String aboutText;
    private final String usageText;
    private final Boolean marketplaceCertified;

    private RepositoryCatalogData(BuilderImpl builder) {
        this.description = builder.description;
        this.architectures = builder.architectures;
        this.operatingSystems = builder.operatingSystems;
        this.logoUrl = builder.logoUrl;
        this.aboutText = builder.aboutText;
        this.usageText = builder.usageText;
        this.marketplaceCertified = builder.marketplaceCertified;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasArchitectures() {
        return this.architectures != null && !(this.architectures instanceof SdkAutoConstructList);
    }

    public final List<String> architectures() {
        return this.architectures;
    }

    public final boolean hasOperatingSystems() {
        return this.operatingSystems != null && !(this.operatingSystems instanceof SdkAutoConstructList);
    }

    public final List<String> operatingSystems() {
        return this.operatingSystems;
    }

    public final String logoUrl() {
        return this.logoUrl;
    }

    public final String aboutText() {
        return this.aboutText;
    }

    public final String usageText() {
        return this.usageText;
    }

    public final Boolean marketplaceCertified() {
        return this.marketplaceCertified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectures() ? this.architectures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOperatingSystems() ? this.operatingSystems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logoUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.aboutText());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageText());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketplaceCertified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryCatalogData)) {
            return false;
        }
        RepositoryCatalogData other = (RepositoryCatalogData)obj;
        return Objects.equals(this.description(), other.description()) && this.hasArchitectures() == other.hasArchitectures() && Objects.equals(this.architectures(), other.architectures()) && this.hasOperatingSystems() == other.hasOperatingSystems() && Objects.equals(this.operatingSystems(), other.operatingSystems()) && Objects.equals(this.logoUrl(), other.logoUrl()) && Objects.equals(this.aboutText(), other.aboutText()) && Objects.equals(this.usageText(), other.usageText()) && Objects.equals(this.marketplaceCertified(), other.marketplaceCertified());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryCatalogData").add("Description", (Object)this.description()).add("Architectures", this.hasArchitectures() ? this.architectures() : null).add("OperatingSystems", this.hasOperatingSystems() ? this.operatingSystems() : null).add("LogoUrl", (Object)this.logoUrl()).add("AboutText", (Object)this.aboutText()).add("UsageText", (Object)this.usageText()).add("MarketplaceCertified", (Object)this.marketplaceCertified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "architectures": {
                return Optional.ofNullable(clazz.cast(this.architectures()));
            }
            case "operatingSystems": {
                return Optional.ofNullable(clazz.cast(this.operatingSystems()));
            }
            case "logoUrl": {
                return Optional.ofNullable(clazz.cast(this.logoUrl()));
            }
            case "aboutText": {
                return Optional.ofNullable(clazz.cast(this.aboutText()));
            }
            case "usageText": {
                return Optional.ofNullable(clazz.cast(this.usageText()));
            }
            case "marketplaceCertified": {
                return Optional.ofNullable(clazz.cast(this.marketplaceCertified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryCatalogData, T> g) {
        return obj -> g.apply((RepositoryCatalogData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private List<String> architectures = DefaultSdkAutoConstructList.getInstance();
        private List<String> operatingSystems = DefaultSdkAutoConstructList.getInstance();
        private String logoUrl;
        private String aboutText;
        private String usageText;
        private Boolean marketplaceCertified;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryCatalogData model) {
            this.description(model.description);
            this.architectures(model.architectures);
            this.operatingSystems(model.operatingSystems);
            this.logoUrl(model.logoUrl);
            this.aboutText(model.aboutText);
            this.usageText(model.usageText);
            this.marketplaceCertified(model.marketplaceCertified);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getArchitectures() {
            if (this.architectures instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectures;
        }

        @Override
        public final Builder architectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder architectures(String ... architectures) {
            this.architectures(Arrays.asList(architectures));
            return this;
        }

        public final void setArchitectures(Collection<String> architectures) {
            this.architectures = ArchitectureListCopier.copy(architectures);
        }

        public final Collection<String> getOperatingSystems() {
            if (this.operatingSystems instanceof SdkAutoConstructList) {
                return null;
            }
            return this.operatingSystems;
        }

        @Override
        public final Builder operatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder operatingSystems(String ... operatingSystems) {
            this.operatingSystems(Arrays.asList(operatingSystems));
            return this;
        }

        public final void setOperatingSystems(Collection<String> operatingSystems) {
            this.operatingSystems = OperatingSystemListCopier.copy(operatingSystems);
        }

        public final String getLogoUrl() {
            return this.logoUrl;
        }

        @Override
        public final Builder logoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
            return this;
        }

        public final void setLogoUrl(String logoUrl) {
            this.logoUrl = logoUrl;
        }

        public final String getAboutText() {
            return this.aboutText;
        }

        @Override
        public final Builder aboutText(String aboutText) {
            this.aboutText = aboutText;
            return this;
        }

        public final void setAboutText(String aboutText) {
            this.aboutText = aboutText;
        }

        public final String getUsageText() {
            return this.usageText;
        }

        @Override
        public final Builder usageText(String usageText) {
            this.usageText = usageText;
            return this;
        }

        public final void setUsageText(String usageText) {
            this.usageText = usageText;
        }

        public final Boolean getMarketplaceCertified() {
            return this.marketplaceCertified;
        }

        @Override
        public final Builder marketplaceCertified(Boolean marketplaceCertified) {
            this.marketplaceCertified = marketplaceCertified;
            return this;
        }

        public final void setMarketplaceCertified(Boolean marketplaceCertified) {
            this.marketplaceCertified = marketplaceCertified;
        }

        public RepositoryCatalogData build() {
            return new RepositoryCatalogData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryCatalogData> {
        public Builder description(String var1);

        public Builder architectures(Collection<String> var1);

        public Builder architectures(String ... var1);

        public Builder operatingSystems(Collection<String> var1);

        public Builder operatingSystems(String ... var1);

        public Builder logoUrl(String var1);

        public Builder aboutText(String var1);

        public Builder usageText(String var1);

        public Builder marketplaceCertified(Boolean var1);
    }
}

