/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.eks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.eks.EksAsyncClient;
import software.amazon.awssdk.services.eks.model.ListUpdatesRequest;
import software.amazon.awssdk.services.eks.model.ListUpdatesResponse;

public class ListUpdatesPublisher
implements SdkPublisher<ListUpdatesResponse> {
    private final EksAsyncClient client;
    private final ListUpdatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUpdatesPublisher(EksAsyncClient client, ListUpdatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUpdatesPublisher(EksAsyncClient client, ListUpdatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUpdatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUpdatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<String> updateIds() {
        Function<ListUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.updateIds() != null) {
                return response.updateIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUpdatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUpdatesResponseFetcher
    implements AsyncPageFetcher<ListUpdatesResponse> {
        private ListUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(ListUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUpdatesResponse> nextPage(ListUpdatesResponse previousPage) {
            if (previousPage == null) {
                return ListUpdatesPublisher.this.client.listUpdates(ListUpdatesPublisher.this.firstRequest);
            }
            return ListUpdatesPublisher.this.client.listUpdates((ListUpdatesRequest)((Object)ListUpdatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

