/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.Country;
import software.amazon.awssdk.services.geoplaces.model.IntersectionStreetListCopier;
import software.amazon.awssdk.services.geoplaces.model.Region;
import software.amazon.awssdk.services.geoplaces.model.SecondaryAddressComponent;
import software.amazon.awssdk.services.geoplaces.model.SecondaryAddressComponentListCopier;
import software.amazon.awssdk.services.geoplaces.model.StreetComponents;
import software.amazon.awssdk.services.geoplaces.model.StreetComponentsListCopier;
import software.amazon.awssdk.services.geoplaces.model.SubRegion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Address
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Address> {
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Label").getter(Address.getter(Address::label)).setter(Address.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<Country> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Country").getter(Address.getter(Address::country)).setter(Address.setter(Builder::country)).constructor(Country::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()}).build();
    private static final SdkField<Region> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Region").getter(Address.getter(Address::region)).setter(Address.setter(Builder::region)).constructor(Region::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<SubRegion> SUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SubRegion").getter(Address.getter(Address::subRegion)).setter(Address.setter(Builder::subRegion)).constructor(SubRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build()}).build();
    private static final SdkField<String> LOCALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locality").getter(Address.getter(Address::locality)).setter(Address.setter(Builder::locality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()}).build();
    private static final SdkField<String> DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("District").getter(Address.getter(Address::district)).setter(Address.setter(Builder::district)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build()}).build();
    private static final SdkField<String> SUB_DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubDistrict").getter(Address.getter(Address::subDistrict)).setter(Address.setter(Builder::subDistrict)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build()}).build();
    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostalCode").getter(Address.getter(Address::postalCode)).setter(Address.setter(Builder::postalCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()}).build();
    private static final SdkField<String> BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Block").getter(Address.getter(Address::block)).setter(Address.setter(Builder::block)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build()}).build();
    private static final SdkField<String> SUB_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubBlock").getter(Address.getter(Address::subBlock)).setter(Address.setter(Builder::subBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build()}).build();
    private static final SdkField<List<String>> INTERSECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Intersection").getter(Address.getter(Address::intersection)).setter(Address.setter(Builder::intersection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Intersection").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Street").getter(Address.getter(Address::street)).setter(Address.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()}).build();
    private static final SdkField<List<StreetComponents>> STREET_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StreetComponents").getter(Address.getter(Address::streetComponents)).setter(Address.setter(Builder::streetComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StreetComponents::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ADDRESS_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AddressNumber").getter(Address.getter(Address::addressNumber)).setter(Address.setter(Builder::addressNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddressNumber").build()}).build();
    private static final SdkField<String> BUILDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Building").getter(Address.getter(Address::building)).setter(Address.setter(Builder::building)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Building").build()}).build();
    private static final SdkField<List<SecondaryAddressComponent>> SECONDARY_ADDRESS_COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecondaryAddressComponents").getter(Address.getter(Address::secondaryAddressComponents)).setter(Address.setter(Builder::secondaryAddressComponents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAddressComponents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecondaryAddressComponent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_FIELD, COUNTRY_FIELD, REGION_FIELD, SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, POSTAL_CODE_FIELD, BLOCK_FIELD, SUB_BLOCK_FIELD, INTERSECTION_FIELD, STREET_FIELD, STREET_COMPONENTS_FIELD, ADDRESS_NUMBER_FIELD, BUILDING_FIELD, SECONDARY_ADDRESS_COMPONENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Address.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String label;
    private final Country country;
    private final Region region;
    private final SubRegion subRegion;
    private final String locality;
    private final String district;
    private final String subDistrict;
    private final String postalCode;
    private final String block;
    private final String subBlock;
    private final List<String> intersection;
    private final String street;
    private final List<StreetComponents> streetComponents;
    private final String addressNumber;
    private final String building;
    private final List<SecondaryAddressComponent> secondaryAddressComponents;

    private Address(BuilderImpl builder) {
        this.label = builder.label;
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.postalCode = builder.postalCode;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.intersection = builder.intersection;
        this.street = builder.street;
        this.streetComponents = builder.streetComponents;
        this.addressNumber = builder.addressNumber;
        this.building = builder.building;
        this.secondaryAddressComponents = builder.secondaryAddressComponents;
    }

    public final String label() {
        return this.label;
    }

    public final Country country() {
        return this.country;
    }

    public final Region region() {
        return this.region;
    }

    public final SubRegion subRegion() {
        return this.subRegion;
    }

    public final String locality() {
        return this.locality;
    }

    public final String district() {
        return this.district;
    }

    public final String subDistrict() {
        return this.subDistrict;
    }

    public final String postalCode() {
        return this.postalCode;
    }

    public final String block() {
        return this.block;
    }

    public final String subBlock() {
        return this.subBlock;
    }

    public final boolean hasIntersection() {
        return this.intersection != null && !(this.intersection instanceof SdkAutoConstructList);
    }

    public final List<String> intersection() {
        return this.intersection;
    }

    public final String street() {
        return this.street;
    }

    public final boolean hasStreetComponents() {
        return this.streetComponents != null && !(this.streetComponents instanceof SdkAutoConstructList);
    }

    public final List<StreetComponents> streetComponents() {
        return this.streetComponents;
    }

    public final String addressNumber() {
        return this.addressNumber;
    }

    public final String building() {
        return this.building;
    }

    public final boolean hasSecondaryAddressComponents() {
        return this.secondaryAddressComponents != null && !(this.secondaryAddressComponents instanceof SdkAutoConstructList);
    }

    public final List<SecondaryAddressComponent> secondaryAddressComponents() {
        return this.secondaryAddressComponents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.country());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.subRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.locality());
        hashCode = 31 * hashCode + Objects.hashCode(this.district());
        hashCode = 31 * hashCode + Objects.hashCode(this.subDistrict());
        hashCode = 31 * hashCode + Objects.hashCode(this.postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.block());
        hashCode = 31 * hashCode + Objects.hashCode(this.subBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIntersection() ? this.intersection() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.street());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreetComponents() ? this.streetComponents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.addressNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.building());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryAddressComponents() ? this.secondaryAddressComponents() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.label(), other.label()) && Objects.equals(this.country(), other.country()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.subRegion(), other.subRegion()) && Objects.equals(this.locality(), other.locality()) && Objects.equals(this.district(), other.district()) && Objects.equals(this.subDistrict(), other.subDistrict()) && Objects.equals(this.postalCode(), other.postalCode()) && Objects.equals(this.block(), other.block()) && Objects.equals(this.subBlock(), other.subBlock()) && this.hasIntersection() == other.hasIntersection() && Objects.equals(this.intersection(), other.intersection()) && Objects.equals(this.street(), other.street()) && this.hasStreetComponents() == other.hasStreetComponents() && Objects.equals(this.streetComponents(), other.streetComponents()) && Objects.equals(this.addressNumber(), other.addressNumber()) && Objects.equals(this.building(), other.building()) && this.hasSecondaryAddressComponents() == other.hasSecondaryAddressComponents() && Objects.equals(this.secondaryAddressComponents(), other.secondaryAddressComponents());
    }

    public final String toString() {
        return ToString.builder((String)"Address").add("Label", (Object)(this.label() == null ? null : "*** Sensitive Data Redacted ***")).add("Country", (Object)this.country()).add("Region", (Object)this.region()).add("SubRegion", (Object)this.subRegion()).add("Locality", (Object)(this.locality() == null ? null : "*** Sensitive Data Redacted ***")).add("District", (Object)(this.district() == null ? null : "*** Sensitive Data Redacted ***")).add("SubDistrict", (Object)(this.subDistrict() == null ? null : "*** Sensitive Data Redacted ***")).add("PostalCode", (Object)(this.postalCode() == null ? null : "*** Sensitive Data Redacted ***")).add("Block", (Object)(this.block() == null ? null : "*** Sensitive Data Redacted ***")).add("SubBlock", (Object)(this.subBlock() == null ? null : "*** Sensitive Data Redacted ***")).add("Intersection", this.hasIntersection() ? this.intersection() : null).add("Street", (Object)(this.street() == null ? null : "*** Sensitive Data Redacted ***")).add("StreetComponents", this.hasStreetComponents() ? this.streetComponents() : null).add("AddressNumber", (Object)(this.addressNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("Building", (Object)(this.building() == null ? null : "*** Sensitive Data Redacted ***")).add("SecondaryAddressComponents", this.hasSecondaryAddressComponents() ? this.secondaryAddressComponents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "SubRegion": {
                return Optional.ofNullable(clazz.cast(this.subRegion()));
            }
            case "Locality": {
                return Optional.ofNullable(clazz.cast(this.locality()));
            }
            case "District": {
                return Optional.ofNullable(clazz.cast(this.district()));
            }
            case "SubDistrict": {
                return Optional.ofNullable(clazz.cast(this.subDistrict()));
            }
            case "PostalCode": {
                return Optional.ofNullable(clazz.cast(this.postalCode()));
            }
            case "Block": {
                return Optional.ofNullable(clazz.cast(this.block()));
            }
            case "SubBlock": {
                return Optional.ofNullable(clazz.cast(this.subBlock()));
            }
            case "Intersection": {
                return Optional.ofNullable(clazz.cast(this.intersection()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
            case "StreetComponents": {
                return Optional.ofNullable(clazz.cast(this.streetComponents()));
            }
            case "AddressNumber": {
                return Optional.ofNullable(clazz.cast(this.addressNumber()));
            }
            case "Building": {
                return Optional.ofNullable(clazz.cast(this.building()));
            }
            case "SecondaryAddressComponents": {
                return Optional.ofNullable(clazz.cast(this.secondaryAddressComponents()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Label", LABEL_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("SubRegion", SUB_REGION_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("District", DISTRICT_FIELD);
        map.put("SubDistrict", SUB_DISTRICT_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("Block", BLOCK_FIELD);
        map.put("SubBlock", SUB_BLOCK_FIELD);
        map.put("Intersection", INTERSECTION_FIELD);
        map.put("Street", STREET_FIELD);
        map.put("StreetComponents", STREET_COMPONENTS_FIELD);
        map.put("AddressNumber", ADDRESS_NUMBER_FIELD);
        map.put("Building", BUILDING_FIELD);
        map.put("SecondaryAddressComponents", SECONDARY_ADDRESS_COMPONENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String label;
        private Country country;
        private Region region;
        private SubRegion subRegion;
        private String locality;
        private String district;
        private String subDistrict;
        private String postalCode;
        private String block;
        private String subBlock;
        private List<String> intersection = DefaultSdkAutoConstructList.getInstance();
        private String street;
        private List<StreetComponents> streetComponents = DefaultSdkAutoConstructList.getInstance();
        private String addressNumber;
        private String building;
        private List<SecondaryAddressComponent> secondaryAddressComponents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.label(model.label);
            this.country(model.country);
            this.region(model.region);
            this.subRegion(model.subRegion);
            this.locality(model.locality);
            this.district(model.district);
            this.subDistrict(model.subDistrict);
            this.postalCode(model.postalCode);
            this.block(model.block);
            this.subBlock(model.subBlock);
            this.intersection(model.intersection);
            this.street(model.street);
            this.streetComponents(model.streetComponents);
            this.addressNumber(model.addressNumber);
            this.building(model.building);
            this.secondaryAddressComponents(model.secondaryAddressComponents);
        }

        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final Country.Builder getCountry() {
            return this.country != null ? this.country.toBuilder() : null;
        }

        public final void setCountry(Country.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        @Override
        public final Builder country(Country country) {
            this.country = country;
            return this;
        }

        public final Region.Builder getRegion() {
            return this.region != null ? this.region.toBuilder() : null;
        }

        public final void setRegion(Region.BuilderImpl region) {
            this.region = region != null ? region.build() : null;
        }

        @Override
        public final Builder region(Region region) {
            this.region = region;
            return this;
        }

        public final SubRegion.Builder getSubRegion() {
            return this.subRegion != null ? this.subRegion.toBuilder() : null;
        }

        public final void setSubRegion(SubRegion.BuilderImpl subRegion) {
            this.subRegion = subRegion != null ? subRegion.build() : null;
        }

        @Override
        public final Builder subRegion(SubRegion subRegion) {
            this.subRegion = subRegion;
            return this;
        }

        public final String getLocality() {
            return this.locality;
        }

        public final void setLocality(String locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public final String getDistrict() {
            return this.district;
        }

        public final void setDistrict(String district) {
            this.district = district;
        }

        @Override
        public final Builder district(String district) {
            this.district = district;
            return this;
        }

        public final String getSubDistrict() {
            return this.subDistrict;
        }

        public final void setSubDistrict(String subDistrict) {
            this.subDistrict = subDistrict;
        }

        @Override
        public final Builder subDistrict(String subDistrict) {
            this.subDistrict = subDistrict;
            return this;
        }

        public final String getPostalCode() {
            return this.postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getBlock() {
            return this.block;
        }

        public final void setBlock(String block) {
            this.block = block;
        }

        @Override
        public final Builder block(String block) {
            this.block = block;
            return this;
        }

        public final String getSubBlock() {
            return this.subBlock;
        }

        public final void setSubBlock(String subBlock) {
            this.subBlock = subBlock;
        }

        @Override
        public final Builder subBlock(String subBlock) {
            this.subBlock = subBlock;
            return this;
        }

        public final Collection<String> getIntersection() {
            if (this.intersection instanceof SdkAutoConstructList) {
                return null;
            }
            return this.intersection;
        }

        public final void setIntersection(Collection<String> intersection) {
            this.intersection = IntersectionStreetListCopier.copy(intersection);
        }

        @Override
        public final Builder intersection(Collection<String> intersection) {
            this.intersection = IntersectionStreetListCopier.copy(intersection);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder intersection(String ... intersection) {
            this.intersection(Arrays.asList(intersection));
            return this;
        }

        public final String getStreet() {
            return this.street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final List<StreetComponents.Builder> getStreetComponents() {
            List<StreetComponents.Builder> result = StreetComponentsListCopier.copyToBuilder(this.streetComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreetComponents(Collection<StreetComponents.BuilderImpl> streetComponents) {
            this.streetComponents = StreetComponentsListCopier.copyFromBuilder(streetComponents);
        }

        @Override
        public final Builder streetComponents(Collection<StreetComponents> streetComponents) {
            this.streetComponents = StreetComponentsListCopier.copy(streetComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streetComponents(StreetComponents ... streetComponents) {
            this.streetComponents(Arrays.asList(streetComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder streetComponents(Consumer<StreetComponents.Builder> ... streetComponents) {
            this.streetComponents(Stream.of(streetComponents).map(c -> (StreetComponents)((StreetComponents.Builder)StreetComponents.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAddressNumber() {
            return this.addressNumber;
        }

        public final void setAddressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
        }

        @Override
        public final Builder addressNumber(String addressNumber) {
            this.addressNumber = addressNumber;
            return this;
        }

        public final String getBuilding() {
            return this.building;
        }

        public final void setBuilding(String building) {
            this.building = building;
        }

        @Override
        public final Builder building(String building) {
            this.building = building;
            return this;
        }

        public final List<SecondaryAddressComponent.Builder> getSecondaryAddressComponents() {
            List<SecondaryAddressComponent.Builder> result = SecondaryAddressComponentListCopier.copyToBuilder(this.secondaryAddressComponents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryAddressComponents(Collection<SecondaryAddressComponent.BuilderImpl> secondaryAddressComponents) {
            this.secondaryAddressComponents = SecondaryAddressComponentListCopier.copyFromBuilder(secondaryAddressComponents);
        }

        @Override
        public final Builder secondaryAddressComponents(Collection<SecondaryAddressComponent> secondaryAddressComponents) {
            this.secondaryAddressComponents = SecondaryAddressComponentListCopier.copy(secondaryAddressComponents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAddressComponents(SecondaryAddressComponent ... secondaryAddressComponents) {
            this.secondaryAddressComponents(Arrays.asList(secondaryAddressComponents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryAddressComponents(Consumer<SecondaryAddressComponent.Builder> ... secondaryAddressComponents) {
            this.secondaryAddressComponents(Stream.of(secondaryAddressComponents).map(c -> (SecondaryAddressComponent)((SecondaryAddressComponent.Builder)SecondaryAddressComponent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Address build() {
            return new Address(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Address> {
        public Builder label(String var1);

        public Builder country(Country var1);

        default public Builder country(Consumer<Country.Builder> country) {
            return this.country((Country)((Country.Builder)Country.builder().applyMutation(country)).build());
        }

        public Builder region(Region var1);

        default public Builder region(Consumer<Region.Builder> region) {
            return this.region((Region)((Region.Builder)Region.builder().applyMutation(region)).build());
        }

        public Builder subRegion(SubRegion var1);

        default public Builder subRegion(Consumer<SubRegion.Builder> subRegion) {
            return this.subRegion((SubRegion)((SubRegion.Builder)SubRegion.builder().applyMutation(subRegion)).build());
        }

        public Builder locality(String var1);

        public Builder district(String var1);

        public Builder subDistrict(String var1);

        public Builder postalCode(String var1);

        public Builder block(String var1);

        public Builder subBlock(String var1);

        public Builder intersection(Collection<String> var1);

        public Builder intersection(String ... var1);

        public Builder street(String var1);

        public Builder streetComponents(Collection<StreetComponents> var1);

        public Builder streetComponents(StreetComponents ... var1);

        public Builder streetComponents(Consumer<StreetComponents.Builder> ... var1);

        public Builder addressNumber(String var1);

        public Builder building(String var1);

        public Builder secondaryAddressComponents(Collection<SecondaryAddressComponent> var1);

        public Builder secondaryAddressComponents(SecondaryAddressComponent ... var1);

        public Builder secondaryAddressComponents(Consumer<SecondaryAddressComponent.Builder> ... var1);
    }
}

