/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.AccessPoint;
import software.amazon.awssdk.services.geoplaces.model.AccessPointListCopier;
import software.amazon.awssdk.services.geoplaces.model.Address;
import software.amazon.awssdk.services.geoplaces.model.PlaceType;
import software.amazon.awssdk.services.geoplaces.model.PositionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RelatedPlace
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RelatedPlace> {
    private static final SdkField<String> PLACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceId").getter(RelatedPlace.getter(RelatedPlace::placeId)).setter(RelatedPlace.setter(Builder::placeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceId").build()}).build();
    private static final SdkField<String> PLACE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaceType").getter(RelatedPlace.getter(RelatedPlace::placeTypeAsString)).setter(RelatedPlace.setter(Builder::placeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(RelatedPlace.getter(RelatedPlace::title)).setter(RelatedPlace.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(RelatedPlace.getter(RelatedPlace::address)).setter(RelatedPlace.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<List<Double>> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Position").getter(RelatedPlace.getter(RelatedPlace::position)).setter(RelatedPlace.setter(Builder::position)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Position").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AccessPoint>> ACCESS_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AccessPoints").getter(RelatedPlace.getter(RelatedPlace::accessPoints)).setter(RelatedPlace.setter(Builder::accessPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLACE_ID_FIELD, PLACE_TYPE_FIELD, TITLE_FIELD, ADDRESS_FIELD, POSITION_FIELD, ACCESS_POINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RelatedPlace.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String placeId;
    private final String placeType;
    private final String title;
    private final Address address;
    private final List<Double> position;
    private final List<AccessPoint> accessPoints;

    private RelatedPlace(BuilderImpl builder) {
        this.placeId = builder.placeId;
        this.placeType = builder.placeType;
        this.title = builder.title;
        this.address = builder.address;
        this.position = builder.position;
        this.accessPoints = builder.accessPoints;
    }

    public final String placeId() {
        return this.placeId;
    }

    public final PlaceType placeType() {
        return PlaceType.fromValue(this.placeType);
    }

    public final String placeTypeAsString() {
        return this.placeType;
    }

    public final String title() {
        return this.title;
    }

    public final Address address() {
        return this.address;
    }

    public final boolean hasPosition() {
        return this.position != null && !(this.position instanceof SdkAutoConstructList);
    }

    public final List<Double> position() {
        return this.position;
    }

    public final boolean hasAccessPoints() {
        return this.accessPoints != null && !(this.accessPoints instanceof SdkAutoConstructList);
    }

    public final List<AccessPoint> accessPoints() {
        return this.accessPoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.placeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.placeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPosition() ? this.position() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAccessPoints() ? this.accessPoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedPlace)) {
            return false;
        }
        RelatedPlace other = (RelatedPlace)obj;
        return Objects.equals(this.placeId(), other.placeId()) && Objects.equals(this.placeTypeAsString(), other.placeTypeAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.address(), other.address()) && this.hasPosition() == other.hasPosition() && Objects.equals(this.position(), other.position()) && this.hasAccessPoints() == other.hasAccessPoints() && Objects.equals(this.accessPoints(), other.accessPoints());
    }

    public final String toString() {
        return ToString.builder((String)"RelatedPlace").add("PlaceId", (Object)(this.placeId() == null ? null : "*** Sensitive Data Redacted ***")).add("PlaceType", (Object)(this.placeTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("Address", (Object)this.address()).add("Position", (Object)(this.position() == null ? null : "*** Sensitive Data Redacted ***")).add("AccessPoints", this.hasAccessPoints() ? this.accessPoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PlaceId": {
                return Optional.ofNullable(clazz.cast(this.placeId()));
            }
            case "PlaceType": {
                return Optional.ofNullable(clazz.cast(this.placeTypeAsString()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "AccessPoints": {
                return Optional.ofNullable(clazz.cast(this.accessPoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PlaceId", PLACE_ID_FIELD);
        map.put("PlaceType", PLACE_TYPE_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("Position", POSITION_FIELD);
        map.put("AccessPoints", ACCESS_POINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedPlace, T> g) {
        return obj -> g.apply((RelatedPlace)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String placeId;
        private String placeType;
        private String title;
        private Address address;
        private List<Double> position = DefaultSdkAutoConstructList.getInstance();
        private List<AccessPoint> accessPoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedPlace model) {
            this.placeId(model.placeId);
            this.placeType(model.placeType);
            this.title(model.title);
            this.address(model.address);
            this.position(model.position);
            this.accessPoints(model.accessPoints);
        }

        public final String getPlaceId() {
            return this.placeId;
        }

        public final void setPlaceId(String placeId) {
            this.placeId = placeId;
        }

        @Override
        public final Builder placeId(String placeId) {
            this.placeId = placeId;
            return this;
        }

        public final String getPlaceType() {
            return this.placeType;
        }

        public final void setPlaceType(String placeType) {
            this.placeType = placeType;
        }

        @Override
        public final Builder placeType(String placeType) {
            this.placeType = placeType;
            return this;
        }

        @Override
        public final Builder placeType(PlaceType placeType) {
            this.placeType(placeType == null ? null : placeType.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Collection<Double> getPosition() {
            if (this.position instanceof SdkAutoConstructList) {
                return null;
            }
            return this.position;
        }

        public final void setPosition(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
        }

        @Override
        public final Builder position(Collection<Double> position) {
            this.position = PositionCopier.copy(position);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder position(Double ... position) {
            this.position(Arrays.asList(position));
            return this;
        }

        public final List<AccessPoint.Builder> getAccessPoints() {
            List<AccessPoint.Builder> result = AccessPointListCopier.copyToBuilder(this.accessPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessPoints(Collection<AccessPoint.BuilderImpl> accessPoints) {
            this.accessPoints = AccessPointListCopier.copyFromBuilder(accessPoints);
        }

        @Override
        public final Builder accessPoints(Collection<AccessPoint> accessPoints) {
            this.accessPoints = AccessPointListCopier.copy(accessPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(AccessPoint ... accessPoints) {
            this.accessPoints(Arrays.asList(accessPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPoints(Consumer<AccessPoint.Builder> ... accessPoints) {
            this.accessPoints(Stream.of(accessPoints).map(c -> (AccessPoint)((AccessPoint.Builder)AccessPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RelatedPlace build() {
            return new RelatedPlace(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RelatedPlace> {
        public Builder placeId(String var1);

        public Builder placeType(String var1);

        public Builder placeType(PlaceType var1);

        public Builder title(String var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder position(Collection<Double> var1);

        public Builder position(Double ... var1);

        public Builder accessPoints(Collection<AccessPoint> var1);

        public Builder accessPoints(AccessPoint ... var1);

        public Builder accessPoints(Consumer<AccessPoint.Builder> ... var1);
    }
}

