/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.PhonemeTranscription;
import software.amazon.awssdk.services.geoplaces.model.PhonemeTranscriptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressComponentPhonemes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressComponentPhonemes> {
    private static final SdkField<List<PhonemeTranscription>> COUNTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Country").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::country)).setter(AddressComponentPhonemes.setter(Builder::country)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Region").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::region)).setter(AddressComponentPhonemes.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> SUB_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubRegion").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::subRegion)).setter(AddressComponentPhonemes.setter(Builder::subRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubRegion").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> LOCALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Locality").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::locality)).setter(AddressComponentPhonemes.setter(Builder::locality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("District").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::district)).setter(AddressComponentPhonemes.setter(Builder::district)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("District").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> SUB_DISTRICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubDistrict").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::subDistrict)).setter(AddressComponentPhonemes.setter(Builder::subDistrict)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDistrict").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Block").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::block)).setter(AddressComponentPhonemes.setter(Builder::block)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Block").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> SUB_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubBlock").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::subBlock)).setter(AddressComponentPhonemes.setter(Builder::subBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubBlock").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PhonemeTranscription>> STREET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Street").getter(AddressComponentPhonemes.getter(AddressComponentPhonemes::street)).setter(AddressComponentPhonemes.setter(Builder::street)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PhonemeTranscription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNTRY_FIELD, REGION_FIELD, SUB_REGION_FIELD, LOCALITY_FIELD, DISTRICT_FIELD, SUB_DISTRICT_FIELD, BLOCK_FIELD, SUB_BLOCK_FIELD, STREET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddressComponentPhonemes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<PhonemeTranscription> country;
    private final List<PhonemeTranscription> region;
    private final List<PhonemeTranscription> subRegion;
    private final List<PhonemeTranscription> locality;
    private final List<PhonemeTranscription> district;
    private final List<PhonemeTranscription> subDistrict;
    private final List<PhonemeTranscription> block;
    private final List<PhonemeTranscription> subBlock;
    private final List<PhonemeTranscription> street;

    private AddressComponentPhonemes(BuilderImpl builder) {
        this.country = builder.country;
        this.region = builder.region;
        this.subRegion = builder.subRegion;
        this.locality = builder.locality;
        this.district = builder.district;
        this.subDistrict = builder.subDistrict;
        this.block = builder.block;
        this.subBlock = builder.subBlock;
        this.street = builder.street;
    }

    public final boolean hasCountry() {
        return this.country != null && !(this.country instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> country() {
        return this.country;
    }

    public final boolean hasRegion() {
        return this.region != null && !(this.region instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> region() {
        return this.region;
    }

    public final boolean hasSubRegion() {
        return this.subRegion != null && !(this.subRegion instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> subRegion() {
        return this.subRegion;
    }

    public final boolean hasLocality() {
        return this.locality != null && !(this.locality instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> locality() {
        return this.locality;
    }

    public final boolean hasDistrict() {
        return this.district != null && !(this.district instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> district() {
        return this.district;
    }

    public final boolean hasSubDistrict() {
        return this.subDistrict != null && !(this.subDistrict instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> subDistrict() {
        return this.subDistrict;
    }

    public final boolean hasBlock() {
        return this.block != null && !(this.block instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> block() {
        return this.block;
    }

    public final boolean hasSubBlock() {
        return this.subBlock != null && !(this.subBlock instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> subBlock() {
        return this.subBlock;
    }

    public final boolean hasStreet() {
        return this.street != null && !(this.street instanceof SdkAutoConstructList);
    }

    public final List<PhonemeTranscription> street() {
        return this.street;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCountry() ? this.country() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegion() ? this.region() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubRegion() ? this.subRegion() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocality() ? this.locality() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistrict() ? this.district() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubDistrict() ? this.subDistrict() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlock() ? this.block() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubBlock() ? this.subBlock() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStreet() ? this.street() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressComponentPhonemes)) {
            return false;
        }
        AddressComponentPhonemes other = (AddressComponentPhonemes)obj;
        return this.hasCountry() == other.hasCountry() && Objects.equals(this.country(), other.country()) && this.hasRegion() == other.hasRegion() && Objects.equals(this.region(), other.region()) && this.hasSubRegion() == other.hasSubRegion() && Objects.equals(this.subRegion(), other.subRegion()) && this.hasLocality() == other.hasLocality() && Objects.equals(this.locality(), other.locality()) && this.hasDistrict() == other.hasDistrict() && Objects.equals(this.district(), other.district()) && this.hasSubDistrict() == other.hasSubDistrict() && Objects.equals(this.subDistrict(), other.subDistrict()) && this.hasBlock() == other.hasBlock() && Objects.equals(this.block(), other.block()) && this.hasSubBlock() == other.hasSubBlock() && Objects.equals(this.subBlock(), other.subBlock()) && this.hasStreet() == other.hasStreet() && Objects.equals(this.street(), other.street());
    }

    public final String toString() {
        return ToString.builder((String)"AddressComponentPhonemes").add("Country", this.hasCountry() ? this.country() : null).add("Region", this.hasRegion() ? this.region() : null).add("SubRegion", this.hasSubRegion() ? this.subRegion() : null).add("Locality", this.hasLocality() ? this.locality() : null).add("District", this.hasDistrict() ? this.district() : null).add("SubDistrict", this.hasSubDistrict() ? this.subDistrict() : null).add("Block", this.hasBlock() ? this.block() : null).add("SubBlock", this.hasSubBlock() ? this.subBlock() : null).add("Street", this.hasStreet() ? this.street() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Country": {
                return Optional.ofNullable(clazz.cast(this.country()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "SubRegion": {
                return Optional.ofNullable(clazz.cast(this.subRegion()));
            }
            case "Locality": {
                return Optional.ofNullable(clazz.cast(this.locality()));
            }
            case "District": {
                return Optional.ofNullable(clazz.cast(this.district()));
            }
            case "SubDistrict": {
                return Optional.ofNullable(clazz.cast(this.subDistrict()));
            }
            case "Block": {
                return Optional.ofNullable(clazz.cast(this.block()));
            }
            case "SubBlock": {
                return Optional.ofNullable(clazz.cast(this.subBlock()));
            }
            case "Street": {
                return Optional.ofNullable(clazz.cast(this.street()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<PhonemeTranscription>>> map = new HashMap<String, SdkField<List<PhonemeTranscription>>>();
        map.put("Country", COUNTRY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("SubRegion", SUB_REGION_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("District", DISTRICT_FIELD);
        map.put("SubDistrict", SUB_DISTRICT_FIELD);
        map.put("Block", BLOCK_FIELD);
        map.put("SubBlock", SUB_BLOCK_FIELD);
        map.put("Street", STREET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressComponentPhonemes, T> g) {
        return obj -> g.apply((AddressComponentPhonemes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PhonemeTranscription> country = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> region = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> subRegion = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> locality = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> district = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> subDistrict = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> block = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> subBlock = DefaultSdkAutoConstructList.getInstance();
        private List<PhonemeTranscription> street = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddressComponentPhonemes model) {
            this.country(model.country);
            this.region(model.region);
            this.subRegion(model.subRegion);
            this.locality(model.locality);
            this.district(model.district);
            this.subDistrict(model.subDistrict);
            this.block(model.block);
            this.subBlock(model.subBlock);
            this.street(model.street);
        }

        public final List<PhonemeTranscription.Builder> getCountry() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.country);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCountry(Collection<PhonemeTranscription.BuilderImpl> country) {
            this.country = PhonemeTranscriptionListCopier.copyFromBuilder(country);
        }

        @Override
        public final Builder country(Collection<PhonemeTranscription> country) {
            this.country = PhonemeTranscriptionListCopier.copy(country);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder country(PhonemeTranscription ... country) {
            this.country(Arrays.asList(country));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder country(Consumer<PhonemeTranscription.Builder> ... country) {
            this.country(Stream.of(country).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getRegion() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.region);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegion(Collection<PhonemeTranscription.BuilderImpl> region) {
            this.region = PhonemeTranscriptionListCopier.copyFromBuilder(region);
        }

        @Override
        public final Builder region(Collection<PhonemeTranscription> region) {
            this.region = PhonemeTranscriptionListCopier.copy(region);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder region(PhonemeTranscription ... region) {
            this.region(Arrays.asList(region));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder region(Consumer<PhonemeTranscription.Builder> ... region) {
            this.region(Stream.of(region).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getSubRegion() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.subRegion);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubRegion(Collection<PhonemeTranscription.BuilderImpl> subRegion) {
            this.subRegion = PhonemeTranscriptionListCopier.copyFromBuilder(subRegion);
        }

        @Override
        public final Builder subRegion(Collection<PhonemeTranscription> subRegion) {
            this.subRegion = PhonemeTranscriptionListCopier.copy(subRegion);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subRegion(PhonemeTranscription ... subRegion) {
            this.subRegion(Arrays.asList(subRegion));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subRegion(Consumer<PhonemeTranscription.Builder> ... subRegion) {
            this.subRegion(Stream.of(subRegion).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getLocality() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.locality);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocality(Collection<PhonemeTranscription.BuilderImpl> locality) {
            this.locality = PhonemeTranscriptionListCopier.copyFromBuilder(locality);
        }

        @Override
        public final Builder locality(Collection<PhonemeTranscription> locality) {
            this.locality = PhonemeTranscriptionListCopier.copy(locality);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(PhonemeTranscription ... locality) {
            this.locality(Arrays.asList(locality));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locality(Consumer<PhonemeTranscription.Builder> ... locality) {
            this.locality(Stream.of(locality).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getDistrict() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.district);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDistrict(Collection<PhonemeTranscription.BuilderImpl> district) {
            this.district = PhonemeTranscriptionListCopier.copyFromBuilder(district);
        }

        @Override
        public final Builder district(Collection<PhonemeTranscription> district) {
            this.district = PhonemeTranscriptionListCopier.copy(district);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(PhonemeTranscription ... district) {
            this.district(Arrays.asList(district));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder district(Consumer<PhonemeTranscription.Builder> ... district) {
            this.district(Stream.of(district).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getSubDistrict() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.subDistrict);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubDistrict(Collection<PhonemeTranscription.BuilderImpl> subDistrict) {
            this.subDistrict = PhonemeTranscriptionListCopier.copyFromBuilder(subDistrict);
        }

        @Override
        public final Builder subDistrict(Collection<PhonemeTranscription> subDistrict) {
            this.subDistrict = PhonemeTranscriptionListCopier.copy(subDistrict);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(PhonemeTranscription ... subDistrict) {
            this.subDistrict(Arrays.asList(subDistrict));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subDistrict(Consumer<PhonemeTranscription.Builder> ... subDistrict) {
            this.subDistrict(Stream.of(subDistrict).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getBlock() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.block);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlock(Collection<PhonemeTranscription.BuilderImpl> block) {
            this.block = PhonemeTranscriptionListCopier.copyFromBuilder(block);
        }

        @Override
        public final Builder block(Collection<PhonemeTranscription> block) {
            this.block = PhonemeTranscriptionListCopier.copy(block);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(PhonemeTranscription ... block) {
            this.block(Arrays.asList(block));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder block(Consumer<PhonemeTranscription.Builder> ... block) {
            this.block(Stream.of(block).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getSubBlock() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.subBlock);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubBlock(Collection<PhonemeTranscription.BuilderImpl> subBlock) {
            this.subBlock = PhonemeTranscriptionListCopier.copyFromBuilder(subBlock);
        }

        @Override
        public final Builder subBlock(Collection<PhonemeTranscription> subBlock) {
            this.subBlock = PhonemeTranscriptionListCopier.copy(subBlock);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(PhonemeTranscription ... subBlock) {
            this.subBlock(Arrays.asList(subBlock));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subBlock(Consumer<PhonemeTranscription.Builder> ... subBlock) {
            this.subBlock(Stream.of(subBlock).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PhonemeTranscription.Builder> getStreet() {
            List<PhonemeTranscription.Builder> result = PhonemeTranscriptionListCopier.copyToBuilder(this.street);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStreet(Collection<PhonemeTranscription.BuilderImpl> street) {
            this.street = PhonemeTranscriptionListCopier.copyFromBuilder(street);
        }

        @Override
        public final Builder street(Collection<PhonemeTranscription> street) {
            this.street = PhonemeTranscriptionListCopier.copy(street);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(PhonemeTranscription ... street) {
            this.street(Arrays.asList(street));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder street(Consumer<PhonemeTranscription.Builder> ... street) {
            this.street(Stream.of(street).map(c -> (PhonemeTranscription)((PhonemeTranscription.Builder)PhonemeTranscription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AddressComponentPhonemes build() {
            return new AddressComponentPhonemes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressComponentPhonemes> {
        public Builder country(Collection<PhonemeTranscription> var1);

        public Builder country(PhonemeTranscription ... var1);

        public Builder country(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder region(Collection<PhonemeTranscription> var1);

        public Builder region(PhonemeTranscription ... var1);

        public Builder region(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder subRegion(Collection<PhonemeTranscription> var1);

        public Builder subRegion(PhonemeTranscription ... var1);

        public Builder subRegion(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder locality(Collection<PhonemeTranscription> var1);

        public Builder locality(PhonemeTranscription ... var1);

        public Builder locality(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder district(Collection<PhonemeTranscription> var1);

        public Builder district(PhonemeTranscription ... var1);

        public Builder district(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder subDistrict(Collection<PhonemeTranscription> var1);

        public Builder subDistrict(PhonemeTranscription ... var1);

        public Builder subDistrict(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder block(Collection<PhonemeTranscription> var1);

        public Builder block(PhonemeTranscription ... var1);

        public Builder block(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder subBlock(Collection<PhonemeTranscription> var1);

        public Builder subBlock(PhonemeTranscription ... var1);

        public Builder subBlock(Consumer<PhonemeTranscription.Builder> ... var1);

        public Builder street(Collection<PhonemeTranscription> var1);

        public Builder street(PhonemeTranscription ... var1);

        public Builder street(Consumer<PhonemeTranscription.Builder> ... var1);
    }
}

