/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.geoplaces.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.geoplaces.model.Highlight;
import software.amazon.awssdk.services.geoplaces.model.HighlightListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CountryHighlights
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CountryHighlights> {
    private static final SdkField<List<Highlight>> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Code").getter(CountryHighlights.getter(CountryHighlights::code)).setter(CountryHighlights.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Highlight>> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Name").getter(CountryHighlights.getter(CountryHighlights::name)).setter(CountryHighlights.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Highlight::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CountryHighlights.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Highlight> code;
    private final List<Highlight> name;

    private CountryHighlights(BuilderImpl builder) {
        this.code = builder.code;
        this.name = builder.name;
    }

    public final boolean hasCode() {
        return this.code != null && !(this.code instanceof SdkAutoConstructList);
    }

    public final List<Highlight> code() {
        return this.code;
    }

    public final boolean hasName() {
        return this.name != null && !(this.name instanceof SdkAutoConstructList);
    }

    public final List<Highlight> name() {
        return this.name;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCode() ? this.code() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasName() ? this.name() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CountryHighlights)) {
            return false;
        }
        CountryHighlights other = (CountryHighlights)obj;
        return this.hasCode() == other.hasCode() && Objects.equals(this.code(), other.code()) && this.hasName() == other.hasName() && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"CountryHighlights").add("Code", this.hasCode() ? this.code() : null).add("Name", this.hasName() ? this.name() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Highlight>>> map = new HashMap<String, SdkField<List<Highlight>>>();
        map.put("Code", CODE_FIELD);
        map.put("Name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CountryHighlights, T> g) {
        return obj -> g.apply((CountryHighlights)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Highlight> code = DefaultSdkAutoConstructList.getInstance();
        private List<Highlight> name = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CountryHighlights model) {
            this.code(model.code);
            this.name(model.name);
        }

        public final List<Highlight.Builder> getCode() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.code);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCode(Collection<Highlight.BuilderImpl> code) {
            this.code = HighlightListCopier.copyFromBuilder(code);
        }

        @Override
        public final Builder code(Collection<Highlight> code) {
            this.code = HighlightListCopier.copy(code);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder code(Highlight ... code) {
            this.code(Arrays.asList(code));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder code(Consumer<Highlight.Builder> ... code) {
            this.code(Stream.of(code).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Highlight.Builder> getName() {
            List<Highlight.Builder> result = HighlightListCopier.copyToBuilder(this.name);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setName(Collection<Highlight.BuilderImpl> name) {
            this.name = HighlightListCopier.copyFromBuilder(name);
        }

        @Override
        public final Builder name(Collection<Highlight> name) {
            this.name = HighlightListCopier.copy(name);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder name(Highlight ... name) {
            this.name(Arrays.asList(name));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder name(Consumer<Highlight.Builder> ... name) {
            this.name(Stream.of(name).map(c -> (Highlight)((Highlight.Builder)Highlight.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CountryHighlights build() {
            return new CountryHighlights(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CountryHighlights> {
        public Builder code(Collection<Highlight> var1);

        public Builder code(Highlight ... var1);

        public Builder code(Consumer<Highlight.Builder> ... var1);

        public Builder name(Collection<Highlight> var1);

        public Builder name(Highlight ... var1);

        public Builder name(Consumer<Highlight.Builder> ... var1);
    }
}

