/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.georoutes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RouteSpanRoadAttribute {
    BRIDGE("Bridge"),
    BUILT_UP_AREA("BuiltUpArea"),
    CONTROLLED_ACCESS_HIGHWAY("ControlledAccessHighway"),
    DIRT_ROAD("DirtRoad"),
    DIVIDED_ROAD("DividedRoad"),
    MOTORWAY("Motorway"),
    PRIVATE_ROAD("PrivateRoad"),
    RAMP("Ramp"),
    RIGHT_HAND_TRAFFIC("RightHandTraffic"),
    ROUNDABOUT("Roundabout"),
    TUNNEL("Tunnel"),
    UNDER_CONSTRUCTION("UnderConstruction"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RouteSpanRoadAttribute> VALUE_MAP;
    private final String value;

    private RouteSpanRoadAttribute(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RouteSpanRoadAttribute fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RouteSpanRoadAttribute> knownValues() {
        EnumSet<RouteSpanRoadAttribute> knownValues = EnumSet.allOf(RouteSpanRoadAttribute.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RouteSpanRoadAttribute.class, RouteSpanRoadAttribute::toString);
    }
}

