/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotdeviceadvisor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TestCaseDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TestCaseDefinition> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(TestCaseDefinition.getter(TestCaseDefinition::id)).setter(TestCaseDefinition.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TEST_CASE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testCaseVersion").getter(TestCaseDefinition.getter(TestCaseDefinition::testCaseVersion)).setter(TestCaseDefinition.setter(Builder::testCaseVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TEST_CASE_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String testCaseVersion;

    private TestCaseDefinition(BuilderImpl builder) {
        this.id = builder.id;
        this.testCaseVersion = builder.testCaseVersion;
    }

    public final String id() {
        return this.id;
    }

    public final String testCaseVersion() {
        return this.testCaseVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.testCaseVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseDefinition)) {
            return false;
        }
        TestCaseDefinition other = (TestCaseDefinition)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.testCaseVersion(), other.testCaseVersion());
    }

    public final String toString() {
        return ToString.builder((String)"TestCaseDefinition").add("Id", (Object)this.id()).add("TestCaseVersion", (Object)this.testCaseVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "testCaseVersion": {
                return Optional.ofNullable(clazz.cast(this.testCaseVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestCaseDefinition, T> g) {
        return obj -> g.apply((TestCaseDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String testCaseVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseDefinition model) {
            this.id(model.id);
            this.testCaseVersion(model.testCaseVersion);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTestCaseVersion() {
            return this.testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(String testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final void setTestCaseVersion(String testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        public TestCaseDefinition build() {
            return new TestCaseDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TestCaseDefinition> {
        public Builder id(String var1);

        public Builder testCaseVersion(String var1);
    }
}

