/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.PortalSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.PortalSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPortalsResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListPortalsResponse> {
    private static final SdkField<List<PortalSummary>> PORTAL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portalSummaries").getter(ListPortalsResponse.getter(ListPortalsResponse::portalSummaries)).setter(ListPortalsResponse.setter(Builder::portalSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortalSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPortalsResponse.getter(ListPortalsResponse::nextToken)).setter(ListPortalsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<PortalSummary> portalSummaries;
    private final String nextToken;

    private ListPortalsResponse(BuilderImpl builder) {
        super(builder);
        this.portalSummaries = builder.portalSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPortalSummaries() {
        return this.portalSummaries != null && !(this.portalSummaries instanceof SdkAutoConstructList);
    }

    public final List<PortalSummary> portalSummaries() {
        return this.portalSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortalSummaries() ? this.portalSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPortalsResponse)) {
            return false;
        }
        ListPortalsResponse other = (ListPortalsResponse)((Object)obj);
        return this.hasPortalSummaries() == other.hasPortalSummaries() && Objects.equals(this.portalSummaries(), other.portalSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPortalsResponse").add("PortalSummaries", this.hasPortalSummaries() ? this.portalSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "portalSummaries": {
                return Optional.ofNullable(clazz.cast(this.portalSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPortalsResponse, T> g) {
        return obj -> g.apply((ListPortalsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<PortalSummary> portalSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPortalsResponse model) {
            super(model);
            this.portalSummaries(model.portalSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<PortalSummary.Builder> getPortalSummaries() {
            if (this.portalSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.portalSummaries != null ? (Collection)this.portalSummaries.stream().map(PortalSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder portalSummaries(Collection<PortalSummary> portalSummaries) {
            this.portalSummaries = PortalSummariesCopier.copy(portalSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portalSummaries(PortalSummary ... portalSummaries) {
            this.portalSummaries(Arrays.asList(portalSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portalSummaries(Consumer<PortalSummary.Builder> ... portalSummaries) {
            this.portalSummaries(Stream.of(portalSummaries).map(c -> (PortalSummary)((PortalSummary.Builder)PortalSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPortalSummaries(Collection<PortalSummary.BuilderImpl> portalSummaries) {
            this.portalSummaries = PortalSummariesCopier.copyFromBuilder(portalSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPortalsResponse build() {
            return new ListPortalsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPortalsResponse> {
        public Builder portalSummaries(Collection<PortalSummary> var1);

        public Builder portalSummaries(PortalSummary ... var1);

        public Builder portalSummaries(Consumer<PortalSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

