/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.model.AssociatedAssetsSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAssociatedAssetsResponse;

public class ListAssociatedAssetsIterable
implements SdkIterable<ListAssociatedAssetsResponse> {
    private final IoTSiteWiseClient client;
    private final ListAssociatedAssetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAssociatedAssetsIterable(IoTSiteWiseClient client, ListAssociatedAssetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAssociatedAssetsResponseFetcher();
    }

    public Iterator<ListAssociatedAssetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssociatedAssetsSummary> assetSummaries() {
        Function<ListAssociatedAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assetSummaries() != null) {
                return response.assetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAssociatedAssetsResponseFetcher
    implements SyncPageFetcher<ListAssociatedAssetsResponse> {
        private ListAssociatedAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAssociatedAssetsResponse nextPage(ListAssociatedAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedAssetsIterable.this.client.listAssociatedAssets(ListAssociatedAssetsIterable.this.firstRequest);
            }
            return ListAssociatedAssetsIterable.this.client.listAssociatedAssets((ListAssociatedAssetsRequest)((Object)ListAssociatedAssetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

