/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttribute;
import software.amazon.awssdk.services.opsworkscm.model.EngineAttributesCopier;
import software.amazon.awssdk.services.opsworkscm.model.MaintenanceStatus;
import software.amazon.awssdk.services.opsworkscm.model.ServerStatus;
import software.amazon.awssdk.services.opsworkscm.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Server
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Server> {
    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress").getter(Server.getter(Server::associatePublicIpAddress)).setter(Server.setter(Builder::associatePublicIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionCount").getter(Server.getter(Server::backupRetentionCount)).setter(Server.setter(Builder::backupRetentionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionCount").build()}).build();
    private static final SdkField<String> SERVER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerName").getter(Server.getter(Server::serverName)).setter(Server.setter(Builder::serverName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerName").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Server.getter(Server::createdAt)).setter(Server.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<String> CLOUD_FORMATION_STACK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudFormationStackArn").getter(Server.getter(Server::cloudFormationStackArn)).setter(Server.setter(Builder::cloudFormationStackArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFormationStackArn").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomDomain").getter(Server.getter(Server::customDomain)).setter(Server.setter(Builder::customDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomDomain").build()}).build();
    private static final SdkField<Boolean> DISABLE_AUTOMATED_BACKUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisableAutomatedBackup").getter(Server.getter(Server::disableAutomatedBackup)).setter(Server.setter(Builder::disableAutomatedBackup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableAutomatedBackup").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(Server.getter(Server::endpoint)).setter(Server.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(Server.getter(Server::engine)).setter(Server.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineModel").getter(Server.getter(Server::engineModel)).setter(Server.setter(Builder::engineModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineModel").build()}).build();
    private static final SdkField<List<EngineAttribute>> ENGINE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EngineAttributes").getter(Server.getter(Server::engineAttributes)).setter(Server.setter(Builder::engineAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngineAttribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(Server.getter(Server::engineVersion)).setter(Server.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceProfileArn").getter(Server.getter(Server::instanceProfileArn)).setter(Server.setter(Builder::instanceProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(Server.getter(Server::instanceType)).setter(Server.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> KEY_PAIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPair").getter(Server.getter(Server::keyPair)).setter(Server.setter(Builder::keyPair)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPair").build()}).build();
    private static final SdkField<String> MAINTENANCE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceStatus").getter(Server.getter(Server::maintenanceStatusAsString)).setter(Server.setter(Builder::maintenanceStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceStatus").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(Server.getter(Server::preferredMaintenanceWindow)).setter(Server.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(Server.getter(Server::preferredBackupWindow)).setter(Server.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(Server.getter(Server::securityGroupIds)).setter(Server.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceRoleArn").getter(Server.getter(Server::serviceRoleArn)).setter(Server.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Server.getter(Server::statusAsString)).setter(Server.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(Server.getter(Server::statusReason)).setter(Server.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(Server.getter(Server::subnetIds)).setter(Server.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServerArn").getter(Server.getter(Server::serverArn)).setter(Server.setter(Builder::serverArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, BACKUP_RETENTION_COUNT_FIELD, SERVER_NAME_FIELD, CREATED_AT_FIELD, CLOUD_FORMATION_STACK_ARN_FIELD, CUSTOM_DOMAIN_FIELD, DISABLE_AUTOMATED_BACKUP_FIELD, ENDPOINT_FIELD, ENGINE_FIELD, ENGINE_MODEL_FIELD, ENGINE_ATTRIBUTES_FIELD, ENGINE_VERSION_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_TYPE_FIELD, KEY_PAIR_FIELD, MAINTENANCE_STATUS_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, SECURITY_GROUP_IDS_FIELD, SERVICE_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, SUBNET_IDS_FIELD, SERVER_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean associatePublicIpAddress;
    private final Integer backupRetentionCount;
    private final String serverName;
    private final Instant createdAt;
    private final String cloudFormationStackArn;
    private final String customDomain;
    private final Boolean disableAutomatedBackup;
    private final String endpoint;
    private final String engine;
    private final String engineModel;
    private final List<EngineAttribute> engineAttributes;
    private final String engineVersion;
    private final String instanceProfileArn;
    private final String instanceType;
    private final String keyPair;
    private final String maintenanceStatus;
    private final String preferredMaintenanceWindow;
    private final String preferredBackupWindow;
    private final List<String> securityGroupIds;
    private final String serviceRoleArn;
    private final String status;
    private final String statusReason;
    private final List<String> subnetIds;
    private final String serverArn;

    private Server(BuilderImpl builder) {
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.backupRetentionCount = builder.backupRetentionCount;
        this.serverName = builder.serverName;
        this.createdAt = builder.createdAt;
        this.cloudFormationStackArn = builder.cloudFormationStackArn;
        this.customDomain = builder.customDomain;
        this.disableAutomatedBackup = builder.disableAutomatedBackup;
        this.endpoint = builder.endpoint;
        this.engine = builder.engine;
        this.engineModel = builder.engineModel;
        this.engineAttributes = builder.engineAttributes;
        this.engineVersion = builder.engineVersion;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.keyPair = builder.keyPair;
        this.maintenanceStatus = builder.maintenanceStatus;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.securityGroupIds = builder.securityGroupIds;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.subnetIds = builder.subnetIds;
        this.serverArn = builder.serverArn;
    }

    public final Boolean associatePublicIpAddress() {
        return this.associatePublicIpAddress;
    }

    public final Integer backupRetentionCount() {
        return this.backupRetentionCount;
    }

    public final String serverName() {
        return this.serverName;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String cloudFormationStackArn() {
        return this.cloudFormationStackArn;
    }

    public final String customDomain() {
        return this.customDomain;
    }

    public final Boolean disableAutomatedBackup() {
        return this.disableAutomatedBackup;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineModel() {
        return this.engineModel;
    }

    public final boolean hasEngineAttributes() {
        return this.engineAttributes != null && !(this.engineAttributes instanceof SdkAutoConstructList);
    }

    public final List<EngineAttribute> engineAttributes() {
        return this.engineAttributes;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String instanceProfileArn() {
        return this.instanceProfileArn;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String keyPair() {
        return this.keyPair;
    }

    public final MaintenanceStatus maintenanceStatus() {
        return MaintenanceStatus.fromValue(this.maintenanceStatus);
    }

    public final String maintenanceStatusAsString() {
        return this.maintenanceStatus;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final ServerStatus status() {
        return ServerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String serverArn() {
        return this.serverArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudFormationStackArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableAutomatedBackup());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEngineAttributes() ? this.engineAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPair());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serverArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Server)) {
            return false;
        }
        Server other = (Server)obj;
        return Objects.equals(this.associatePublicIpAddress(), other.associatePublicIpAddress()) && Objects.equals(this.backupRetentionCount(), other.backupRetentionCount()) && Objects.equals(this.serverName(), other.serverName()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.cloudFormationStackArn(), other.cloudFormationStackArn()) && Objects.equals(this.customDomain(), other.customDomain()) && Objects.equals(this.disableAutomatedBackup(), other.disableAutomatedBackup()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineModel(), other.engineModel()) && this.hasEngineAttributes() == other.hasEngineAttributes() && Objects.equals(this.engineAttributes(), other.engineAttributes()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.instanceProfileArn(), other.instanceProfileArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.keyPair(), other.keyPair()) && Objects.equals(this.maintenanceStatusAsString(), other.maintenanceStatusAsString()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.serverArn(), other.serverArn());
    }

    public final String toString() {
        return ToString.builder((String)"Server").add("AssociatePublicIpAddress", (Object)this.associatePublicIpAddress()).add("BackupRetentionCount", (Object)this.backupRetentionCount()).add("ServerName", (Object)this.serverName()).add("CreatedAt", (Object)this.createdAt()).add("CloudFormationStackArn", (Object)this.cloudFormationStackArn()).add("CustomDomain", (Object)this.customDomain()).add("DisableAutomatedBackup", (Object)this.disableAutomatedBackup()).add("Endpoint", (Object)this.endpoint()).add("Engine", (Object)this.engine()).add("EngineModel", (Object)this.engineModel()).add("EngineAttributes", this.hasEngineAttributes() ? this.engineAttributes() : null).add("EngineVersion", (Object)this.engineVersion()).add("InstanceProfileArn", (Object)this.instanceProfileArn()).add("InstanceType", (Object)this.instanceType()).add("KeyPair", (Object)this.keyPair()).add("MaintenanceStatus", (Object)this.maintenanceStatusAsString()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("ServerArn", (Object)this.serverArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociatePublicIpAddress": {
                return Optional.ofNullable(clazz.cast(this.associatePublicIpAddress()));
            }
            case "BackupRetentionCount": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionCount()));
            }
            case "ServerName": {
                return Optional.ofNullable(clazz.cast(this.serverName()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CloudFormationStackArn": {
                return Optional.ofNullable(clazz.cast(this.cloudFormationStackArn()));
            }
            case "CustomDomain": {
                return Optional.ofNullable(clazz.cast(this.customDomain()));
            }
            case "DisableAutomatedBackup": {
                return Optional.ofNullable(clazz.cast(this.disableAutomatedBackup()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineModel": {
                return Optional.ofNullable(clazz.cast(this.engineModel()));
            }
            case "EngineAttributes": {
                return Optional.ofNullable(clazz.cast(this.engineAttributes()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "InstanceProfileArn": {
                return Optional.ofNullable(clazz.cast(this.instanceProfileArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "KeyPair": {
                return Optional.ofNullable(clazz.cast(this.keyPair()));
            }
            case "MaintenanceStatus": {
                return Optional.ofNullable(clazz.cast(this.maintenanceStatusAsString()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "ServiceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "ServerArn": {
                return Optional.ofNullable(clazz.cast(this.serverArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Server, T> g) {
        return obj -> g.apply((Server)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean associatePublicIpAddress;
        private Integer backupRetentionCount;
        private String serverName;
        private Instant createdAt;
        private String cloudFormationStackArn;
        private String customDomain;
        private Boolean disableAutomatedBackup;
        private String endpoint;
        private String engine;
        private String engineModel;
        private List<EngineAttribute> engineAttributes = DefaultSdkAutoConstructList.getInstance();
        private String engineVersion;
        private String instanceProfileArn;
        private String instanceType;
        private String keyPair;
        private String maintenanceStatus;
        private String preferredMaintenanceWindow;
        private String preferredBackupWindow;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String serviceRoleArn;
        private String status;
        private String statusReason;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String serverArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Server model) {
            this.associatePublicIpAddress(model.associatePublicIpAddress);
            this.backupRetentionCount(model.backupRetentionCount);
            this.serverName(model.serverName);
            this.createdAt(model.createdAt);
            this.cloudFormationStackArn(model.cloudFormationStackArn);
            this.customDomain(model.customDomain);
            this.disableAutomatedBackup(model.disableAutomatedBackup);
            this.endpoint(model.endpoint);
            this.engine(model.engine);
            this.engineModel(model.engineModel);
            this.engineAttributes(model.engineAttributes);
            this.engineVersion(model.engineVersion);
            this.instanceProfileArn(model.instanceProfileArn);
            this.instanceType(model.instanceType);
            this.keyPair(model.keyPair);
            this.maintenanceStatus(model.maintenanceStatus);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.securityGroupIds(model.securityGroupIds);
            this.serviceRoleArn(model.serviceRoleArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.subnetIds(model.subnetIds);
            this.serverArn(model.serverArn);
        }

        public final Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        public final Integer getBackupRetentionCount() {
            return this.backupRetentionCount;
        }

        @Override
        public final Builder backupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
            return this;
        }

        public final void setBackupRetentionCount(Integer backupRetentionCount) {
            this.backupRetentionCount = backupRetentionCount;
        }

        public final String getServerName() {
            return this.serverName;
        }

        @Override
        public final Builder serverName(String serverName) {
            this.serverName = serverName;
            return this;
        }

        public final void setServerName(String serverName) {
            this.serverName = serverName;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCloudFormationStackArn() {
            return this.cloudFormationStackArn;
        }

        @Override
        public final Builder cloudFormationStackArn(String cloudFormationStackArn) {
            this.cloudFormationStackArn = cloudFormationStackArn;
            return this;
        }

        public final void setCloudFormationStackArn(String cloudFormationStackArn) {
            this.cloudFormationStackArn = cloudFormationStackArn;
        }

        public final String getCustomDomain() {
            return this.customDomain;
        }

        @Override
        public final Builder customDomain(String customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        public final void setCustomDomain(String customDomain) {
            this.customDomain = customDomain;
        }

        public final Boolean getDisableAutomatedBackup() {
            return this.disableAutomatedBackup;
        }

        @Override
        public final Builder disableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
            return this;
        }

        public final void setDisableAutomatedBackup(Boolean disableAutomatedBackup) {
            this.disableAutomatedBackup = disableAutomatedBackup;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public final String getEngine() {
            return this.engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        public final String getEngineModel() {
            return this.engineModel;
        }

        @Override
        public final Builder engineModel(String engineModel) {
            this.engineModel = engineModel;
            return this;
        }

        public final void setEngineModel(String engineModel) {
            this.engineModel = engineModel;
        }

        public final Collection<EngineAttribute.Builder> getEngineAttributes() {
            if (this.engineAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.engineAttributes != null ? (Collection)this.engineAttributes.stream().map(EngineAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder engineAttributes(Collection<EngineAttribute> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copy(engineAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(EngineAttribute ... engineAttributes) {
            this.engineAttributes(Arrays.asList(engineAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engineAttributes(Consumer<EngineAttribute.Builder> ... engineAttributes) {
            this.engineAttributes(Stream.of(engineAttributes).map(c -> (EngineAttribute)((EngineAttribute.Builder)EngineAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEngineAttributes(Collection<EngineAttribute.BuilderImpl> engineAttributes) {
            this.engineAttributes = EngineAttributesCopier.copyFromBuilder(engineAttributes);
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final String getInstanceProfileArn() {
            return this.instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final Builder keyPair(String keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public final void setKeyPair(String keyPair) {
            this.keyPair = keyPair;
        }

        public final String getMaintenanceStatus() {
            return this.maintenanceStatus;
        }

        @Override
        public final Builder maintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
            return this;
        }

        @Override
        public final Builder maintenanceStatus(MaintenanceStatus maintenanceStatus) {
            this.maintenanceStatus(maintenanceStatus == null ? null : maintenanceStatus.toString());
            return this;
        }

        public final void setMaintenanceStatus(String maintenanceStatus) {
            this.maintenanceStatus = maintenanceStatus;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ServerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final String getServerArn() {
            return this.serverArn;
        }

        @Override
        public final Builder serverArn(String serverArn) {
            this.serverArn = serverArn;
            return this;
        }

        public final void setServerArn(String serverArn) {
            this.serverArn = serverArn;
        }

        public Server build() {
            return new Server(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Server> {
        public Builder associatePublicIpAddress(Boolean var1);

        public Builder backupRetentionCount(Integer var1);

        public Builder serverName(String var1);

        public Builder createdAt(Instant var1);

        public Builder cloudFormationStackArn(String var1);

        public Builder customDomain(String var1);

        public Builder disableAutomatedBackup(Boolean var1);

        public Builder endpoint(String var1);

        public Builder engine(String var1);

        public Builder engineModel(String var1);

        public Builder engineAttributes(Collection<EngineAttribute> var1);

        public Builder engineAttributes(EngineAttribute ... var1);

        public Builder engineAttributes(Consumer<EngineAttribute.Builder> ... var1);

        public Builder engineVersion(String var1);

        public Builder instanceProfileArn(String var1);

        public Builder instanceType(String var1);

        public Builder keyPair(String var1);

        public Builder maintenanceStatus(String var1);

        public Builder maintenanceStatus(MaintenanceStatus var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(ServerStatus var1);

        public Builder statusReason(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder serverArn(String var1);
    }
}

