/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.DataShare;
import software.amazon.awssdk.services.redshift.model.DataShareListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDataSharesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeDataSharesResponse> {
    private static final SdkField<List<DataShare>> DATA_SHARES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataShares").getter(DescribeDataSharesResponse.getter(DescribeDataSharesResponse::dataShares)).setter(DescribeDataSharesResponse.setter(Builder::dataShares)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShares").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataShare::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDataSharesResponse.getter(DescribeDataSharesResponse::marker)).setter(DescribeDataSharesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARES_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDataSharesResponse.memberNameToFieldInitializer();
    private final List<DataShare> dataShares;
    private final String marker;

    private DescribeDataSharesResponse(BuilderImpl builder) {
        super(builder);
        this.dataShares = builder.dataShares;
        this.marker = builder.marker;
    }

    public final boolean hasDataShares() {
        return this.dataShares != null && !(this.dataShares instanceof SdkAutoConstructList);
    }

    public final List<DataShare> dataShares() {
        return this.dataShares;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataShares() ? this.dataShares() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSharesResponse)) {
            return false;
        }
        DescribeDataSharesResponse other = (DescribeDataSharesResponse)((Object)obj);
        return this.hasDataShares() == other.hasDataShares() && Objects.equals(this.dataShares(), other.dataShares()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDataSharesResponse").add("DataShares", this.hasDataShares() ? this.dataShares() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataShares": {
                return Optional.ofNullable(clazz.cast(this.dataShares()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataShares", DATA_SHARES_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSharesResponse, T> g) {
        return obj -> g.apply((DescribeDataSharesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<DataShare> dataShares = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSharesResponse model) {
            super(model);
            this.dataShares(model.dataShares);
            this.marker(model.marker);
        }

        public final List<DataShare.Builder> getDataShares() {
            List<DataShare.Builder> result = DataShareListCopier.copyToBuilder(this.dataShares);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataShares(Collection<DataShare.BuilderImpl> dataShares) {
            this.dataShares = DataShareListCopier.copyFromBuilder(dataShares);
        }

        @Override
        public final Builder dataShares(Collection<DataShare> dataShares) {
            this.dataShares = DataShareListCopier.copy(dataShares);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataShares(DataShare ... dataShares) {
            this.dataShares(Arrays.asList(dataShares));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataShares(Consumer<DataShare.Builder> ... dataShares) {
            this.dataShares(Stream.of(dataShares).map(c -> (DataShare)((DataShare.Builder)DataShare.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDataSharesResponse build() {
            return new DescribeDataSharesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDataSharesResponse> {
        public Builder dataShares(Collection<DataShare> var1);

        public Builder dataShares(DataShare ... var1);

        public Builder dataShares(Consumer<DataShare.Builder> ... var1);

        public Builder marker(String var1);
    }
}

