/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.ScheduleDefinitionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifySnapshotScheduleRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifySnapshotScheduleRequest> {
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleIdentifier").getter(ModifySnapshotScheduleRequest.getter(ModifySnapshotScheduleRequest::scheduleIdentifier)).setter(ModifySnapshotScheduleRequest.setter(Builder::scheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build()}).build();
    private static final SdkField<List<String>> SCHEDULE_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScheduleDefinitions").getter(ModifySnapshotScheduleRequest.getter(ModifySnapshotScheduleRequest::scheduleDefinitions)).setter(ModifySnapshotScheduleRequest.setter(Builder::scheduleDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinitions").build(), ListTrait.builder().memberLocationName("ScheduleDefinition").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleDefinition").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULE_IDENTIFIER_FIELD, SCHEDULE_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifySnapshotScheduleRequest.memberNameToFieldInitializer();
    private final String scheduleIdentifier;
    private final List<String> scheduleDefinitions;

    private ModifySnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.scheduleDefinitions = builder.scheduleDefinitions;
    }

    public final String scheduleIdentifier() {
        return this.scheduleIdentifier;
    }

    public final boolean hasScheduleDefinitions() {
        return this.scheduleDefinitions != null && !(this.scheduleDefinitions instanceof SdkAutoConstructList);
    }

    public final List<String> scheduleDefinitions() {
        return this.scheduleDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScheduleDefinitions() ? this.scheduleDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifySnapshotScheduleRequest)) {
            return false;
        }
        ModifySnapshotScheduleRequest other = (ModifySnapshotScheduleRequest)((Object)obj);
        return Objects.equals(this.scheduleIdentifier(), other.scheduleIdentifier()) && this.hasScheduleDefinitions() == other.hasScheduleDefinitions() && Objects.equals(this.scheduleDefinitions(), other.scheduleDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"ModifySnapshotScheduleRequest").add("ScheduleIdentifier", (Object)this.scheduleIdentifier()).add("ScheduleDefinitions", this.hasScheduleDefinitions() ? this.scheduleDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.scheduleIdentifier()));
            }
            case "ScheduleDefinitions": {
                return Optional.ofNullable(clazz.cast(this.scheduleDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ScheduleIdentifier", SCHEDULE_IDENTIFIER_FIELD);
        map.put("ScheduleDefinitions", SCHEDULE_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifySnapshotScheduleRequest, T> g) {
        return obj -> g.apply((ModifySnapshotScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String scheduleIdentifier;
        private List<String> scheduleDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifySnapshotScheduleRequest model) {
            super(model);
            this.scheduleIdentifier(model.scheduleIdentifier);
            this.scheduleDefinitions(model.scheduleDefinitions);
        }

        public final String getScheduleIdentifier() {
            return this.scheduleIdentifier;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final Collection<String> getScheduleDefinitions() {
            if (this.scheduleDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scheduleDefinitions;
        }

        public final void setScheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
        }

        @Override
        public final Builder scheduleDefinitions(Collection<String> scheduleDefinitions) {
            this.scheduleDefinitions = ScheduleDefinitionListCopier.copy(scheduleDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleDefinitions(String ... scheduleDefinitions) {
            this.scheduleDefinitions(Arrays.asList(scheduleDefinitions));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifySnapshotScheduleRequest build() {
            return new ModifySnapshotScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifySnapshotScheduleRequest> {
        public Builder scheduleIdentifier(String var1);

        public Builder scheduleDefinitions(Collection<String> var1);

        public Builder scheduleDefinitions(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

