/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.ListRecommendationsRequest;
import software.amazon.awssdk.services.redshift.model.ListRecommendationsResponse;
import software.amazon.awssdk.services.redshift.model.Recommendation;

public class ListRecommendationsIterable
implements SdkIterable<ListRecommendationsResponse> {
    private final RedshiftClient client;
    private final ListRecommendationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRecommendationsIterable(RedshiftClient client, ListRecommendationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRecommendationsResponseFetcher();
    }

    public Iterator<ListRecommendationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Recommendation> recommendations() {
        Function<ListRecommendationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendations() != null) {
                return response.recommendations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRecommendationsResponseFetcher
    implements SyncPageFetcher<ListRecommendationsResponse> {
        private ListRecommendationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListRecommendationsResponse nextPage(ListRecommendationsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendationsIterable.this.client.listRecommendations(ListRecommendationsIterable.this.firstRequest);
            }
            return ListRecommendationsIterable.this.client.listRecommendations((ListRecommendationsRequest)((Object)ListRecommendationsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

