/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizeDataShareRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, AuthorizeDataShareRequest> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataShareArn").getter(AuthorizeDataShareRequest.getter(AuthorizeDataShareRequest::dataShareArn)).setter(AuthorizeDataShareRequest.setter(Builder::dataShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()}).build();
    private static final SdkField<String> CONSUMER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsumerIdentifier").getter(AuthorizeDataShareRequest.getter(AuthorizeDataShareRequest::consumerIdentifier)).setter(AuthorizeDataShareRequest.setter(Builder::consumerIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsumerIdentifier").build()}).build();
    private static final SdkField<Boolean> ALLOW_WRITES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowWrites").getter(AuthorizeDataShareRequest.getter(AuthorizeDataShareRequest::allowWrites)).setter(AuthorizeDataShareRequest.setter(Builder::allowWrites)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowWrites").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD, CONSUMER_IDENTIFIER_FIELD, ALLOW_WRITES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthorizeDataShareRequest.memberNameToFieldInitializer();
    private final String dataShareArn;
    private final String consumerIdentifier;
    private final Boolean allowWrites;

    private AuthorizeDataShareRequest(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.consumerIdentifier = builder.consumerIdentifier;
        this.allowWrites = builder.allowWrites;
    }

    public final String dataShareArn() {
        return this.dataShareArn;
    }

    public final String consumerIdentifier() {
        return this.consumerIdentifier;
    }

    public final Boolean allowWrites() {
        return this.allowWrites;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.consumerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowWrites());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeDataShareRequest)) {
            return false;
        }
        AuthorizeDataShareRequest other = (AuthorizeDataShareRequest)((Object)obj);
        return Objects.equals(this.dataShareArn(), other.dataShareArn()) && Objects.equals(this.consumerIdentifier(), other.consumerIdentifier()) && Objects.equals(this.allowWrites(), other.allowWrites());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizeDataShareRequest").add("DataShareArn", (Object)this.dataShareArn()).add("ConsumerIdentifier", (Object)this.consumerIdentifier()).add("AllowWrites", (Object)this.allowWrites()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataShareArn": {
                return Optional.ofNullable(clazz.cast(this.dataShareArn()));
            }
            case "ConsumerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.consumerIdentifier()));
            }
            case "AllowWrites": {
                return Optional.ofNullable(clazz.cast(this.allowWrites()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DataShareArn", DATA_SHARE_ARN_FIELD);
        map.put("ConsumerIdentifier", CONSUMER_IDENTIFIER_FIELD);
        map.put("AllowWrites", ALLOW_WRITES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeDataShareRequest, T> g) {
        return obj -> g.apply((AuthorizeDataShareRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String dataShareArn;
        private String consumerIdentifier;
        private Boolean allowWrites;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeDataShareRequest model) {
            super(model);
            this.dataShareArn(model.dataShareArn);
            this.consumerIdentifier(model.consumerIdentifier);
            this.allowWrites(model.allowWrites);
        }

        public final String getDataShareArn() {
            return this.dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final String getConsumerIdentifier() {
            return this.consumerIdentifier;
        }

        public final void setConsumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
        }

        @Override
        public final Builder consumerIdentifier(String consumerIdentifier) {
            this.consumerIdentifier = consumerIdentifier;
            return this;
        }

        public final Boolean getAllowWrites() {
            return this.allowWrites;
        }

        public final void setAllowWrites(Boolean allowWrites) {
            this.allowWrites = allowWrites;
        }

        @Override
        public final Builder allowWrites(Boolean allowWrites) {
            this.allowWrites = allowWrites;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeDataShareRequest build() {
            return new AuthorizeDataShareRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AuthorizeDataShareRequest> {
        public Builder dataShareArn(String var1);

        public Builder consumerIdentifier(String var1);

        public Builder allowWrites(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

