/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.Subnet;
import software.amazon.awssdk.services.redshift.model.SubnetListCopier;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.services.redshift.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSubnetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterSubnetGroup> {
    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSubnetGroupName").getter(ClusterSubnetGroup.getter(ClusterSubnetGroup::clusterSubnetGroupName)).setter(ClusterSubnetGroup.setter(Builder::clusterSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ClusterSubnetGroup.getter(ClusterSubnetGroup::description)).setter(ClusterSubnetGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(ClusterSubnetGroup.getter(ClusterSubnetGroup::vpcId)).setter(ClusterSubnetGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> SUBNET_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupStatus").getter(ClusterSubnetGroup.getter(ClusterSubnetGroup::subnetGroupStatus)).setter(ClusterSubnetGroup.setter(Builder::subnetGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupStatus").build()}).build();
    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(ClusterSubnetGroup.getter(ClusterSubnetGroup::subnets)).setter(ClusterSubnetGroup.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName("Subnet").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnet").build()}).build()).build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ClusterSubnetGroup.getter(ClusterSubnetGroup::tags)).setter(ClusterSubnetGroup.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUPPORTED_CLUSTER_IP_ADDRESS_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedClusterIpAddressTypes").getter(ClusterSubnetGroup.getter(ClusterSubnetGroup::supportedClusterIpAddressTypes)).setter(ClusterSubnetGroup.setter(Builder::supportedClusterIpAddressTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedClusterIpAddressTypes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SUBNET_GROUP_NAME_FIELD, DESCRIPTION_FIELD, VPC_ID_FIELD, SUBNET_GROUP_STATUS_FIELD, SUBNETS_FIELD, TAGS_FIELD, SUPPORTED_CLUSTER_IP_ADDRESS_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterSubnetGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterSubnetGroupName;
    private final String description;
    private final String vpcId;
    private final String subnetGroupStatus;
    private final List<Subnet> subnets;
    private final List<Tag> tags;
    private final List<String> supportedClusterIpAddressTypes;

    private ClusterSubnetGroup(BuilderImpl builder) {
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnetGroupStatus = builder.subnetGroupStatus;
        this.subnets = builder.subnets;
        this.tags = builder.tags;
        this.supportedClusterIpAddressTypes = builder.supportedClusterIpAddressTypes;
    }

    public final String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public final String description() {
        return this.description;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String subnetGroupStatus() {
        return this.subnetGroupStatus;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<Subnet> subnets() {
        return this.subnets;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final boolean hasSupportedClusterIpAddressTypes() {
        return this.supportedClusterIpAddressTypes != null && !(this.supportedClusterIpAddressTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedClusterIpAddressTypes() {
        return this.supportedClusterIpAddressTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedClusterIpAddressTypes() ? this.supportedClusterIpAddressTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSubnetGroup)) {
            return false;
        }
        ClusterSubnetGroup other = (ClusterSubnetGroup)obj;
        return Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.subnetGroupStatus(), other.subnetGroupStatus()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasSupportedClusterIpAddressTypes() == other.hasSupportedClusterIpAddressTypes() && Objects.equals(this.supportedClusterIpAddressTypes(), other.supportedClusterIpAddressTypes());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterSubnetGroup").add("ClusterSubnetGroupName", (Object)this.clusterSubnetGroupName()).add("Description", (Object)this.description()).add("VpcId", (Object)this.vpcId()).add("SubnetGroupStatus", (Object)this.subnetGroupStatus()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("Tags", this.hasTags() ? this.tags() : null).add("SupportedClusterIpAddressTypes", this.hasSupportedClusterIpAddressTypes() ? this.supportedClusterIpAddressTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupStatus()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SupportedClusterIpAddressTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedClusterIpAddressTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterSubnetGroupName", CLUSTER_SUBNET_GROUP_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetGroupStatus", SUBNET_GROUP_STATUS_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SupportedClusterIpAddressTypes", SUPPORTED_CLUSTER_IP_ADDRESS_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterSubnetGroup, T> g) {
        return obj -> g.apply((ClusterSubnetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterSubnetGroupName;
        private String description;
        private String vpcId;
        private String subnetGroupStatus;
        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private List<String> supportedClusterIpAddressTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSubnetGroup model) {
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.description(model.description);
            this.vpcId(model.vpcId);
            this.subnetGroupStatus(model.subnetGroupStatus);
            this.subnets(model.subnets);
            this.tags(model.tags);
            this.supportedClusterIpAddressTypes(model.supportedClusterIpAddressTypes);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSubnetGroupStatus() {
            return this.subnetGroupStatus;
        }

        public final void setSubnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
        }

        @Override
        public final Builder subnetGroupStatus(String subnetGroupStatus) {
            this.subnetGroupStatus = subnetGroupStatus;
            return this;
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder> ... subnets) {
            this.subnets(Stream.of(subnets).map(c -> (Subnet)((Subnet.Builder)Subnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSupportedClusterIpAddressTypes() {
            if (this.supportedClusterIpAddressTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedClusterIpAddressTypes;
        }

        public final void setSupportedClusterIpAddressTypes(Collection<String> supportedClusterIpAddressTypes) {
            this.supportedClusterIpAddressTypes = ValueStringListCopier.copy(supportedClusterIpAddressTypes);
        }

        @Override
        public final Builder supportedClusterIpAddressTypes(Collection<String> supportedClusterIpAddressTypes) {
            this.supportedClusterIpAddressTypes = ValueStringListCopier.copy(supportedClusterIpAddressTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedClusterIpAddressTypes(String ... supportedClusterIpAddressTypes) {
            this.supportedClusterIpAddressTypes(Arrays.asList(supportedClusterIpAddressTypes));
            return this;
        }

        public ClusterSubnetGroup build() {
            return new ClusterSubnetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterSubnetGroup> {
        public Builder clusterSubnetGroupName(String var1);

        public Builder description(String var1);

        public Builder vpcId(String var1);

        public Builder subnetGroupStatus(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder subnets(Consumer<Subnet.Builder> ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder supportedClusterIpAddressTypes(Collection<String> var1);

        public Builder supportedClusterIpAddressTypes(String ... var1);
    }
}

