/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.RRType;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListResourceRecordSetsRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListResourceRecordSetsRequest> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HostedZoneId").getter(ListResourceRecordSetsRequest.getter(ListResourceRecordSetsRequest::hostedZoneId)).setter(ListResourceRecordSetsRequest.setter(Builder::hostedZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id").build()}).build();
    private static final SdkField<String> START_RECORD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartRecordName").getter(ListResourceRecordSetsRequest.getter(ListResourceRecordSetsRequest::startRecordName)).setter(ListResourceRecordSetsRequest.setter(Builder::startRecordName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").unmarshallLocationName("name").build()}).build();
    private static final SdkField<String> START_RECORD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartRecordType").getter(ListResourceRecordSetsRequest.getter(ListResourceRecordSetsRequest::startRecordTypeAsString)).setter(ListResourceRecordSetsRequest.setter(Builder::startRecordType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").unmarshallLocationName("type").build()}).build();
    private static final SdkField<String> START_RECORD_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartRecordIdentifier").getter(ListResourceRecordSetsRequest.getter(ListResourceRecordSetsRequest::startRecordIdentifier)).setter(ListResourceRecordSetsRequest.setter(Builder::startRecordIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("identifier").unmarshallLocationName("identifier").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListResourceRecordSetsRequest.getter(ListResourceRecordSetsRequest::maxItems)).setter(ListResourceRecordSetsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems").unmarshallLocationName("maxitems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD, START_RECORD_NAME_FIELD, START_RECORD_TYPE_FIELD, START_RECORD_IDENTIFIER_FIELD, MAX_ITEMS_FIELD));
    private final String hostedZoneId;
    private final String startRecordName;
    private final String startRecordType;
    private final String startRecordIdentifier;
    private final String maxItems;

    private ListResourceRecordSetsRequest(BuilderImpl builder) {
        super(builder);
        this.hostedZoneId = builder.hostedZoneId;
        this.startRecordName = builder.startRecordName;
        this.startRecordType = builder.startRecordType;
        this.startRecordIdentifier = builder.startRecordIdentifier;
        this.maxItems = builder.maxItems;
    }

    public final String hostedZoneId() {
        return this.hostedZoneId;
    }

    public final String startRecordName() {
        return this.startRecordName;
    }

    public final RRType startRecordType() {
        return RRType.fromValue(this.startRecordType);
    }

    public final String startRecordTypeAsString() {
        return this.startRecordType;
    }

    public final String startRecordIdentifier() {
        return this.startRecordIdentifier;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startRecordName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startRecordTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startRecordIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceRecordSetsRequest)) {
            return false;
        }
        ListResourceRecordSetsRequest other = (ListResourceRecordSetsRequest)((Object)obj);
        return Objects.equals(this.hostedZoneId(), other.hostedZoneId()) && Objects.equals(this.startRecordName(), other.startRecordName()) && Objects.equals(this.startRecordTypeAsString(), other.startRecordTypeAsString()) && Objects.equals(this.startRecordIdentifier(), other.startRecordIdentifier()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListResourceRecordSetsRequest").add("HostedZoneId", (Object)this.hostedZoneId()).add("StartRecordName", (Object)this.startRecordName()).add("StartRecordType", (Object)this.startRecordTypeAsString()).add("StartRecordIdentifier", (Object)this.startRecordIdentifier()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HostedZoneId": {
                return Optional.ofNullable(clazz.cast(this.hostedZoneId()));
            }
            case "StartRecordName": {
                return Optional.ofNullable(clazz.cast(this.startRecordName()));
            }
            case "StartRecordType": {
                return Optional.ofNullable(clazz.cast(this.startRecordTypeAsString()));
            }
            case "StartRecordIdentifier": {
                return Optional.ofNullable(clazz.cast(this.startRecordIdentifier()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceRecordSetsRequest, T> g) {
        return obj -> g.apply((ListResourceRecordSetsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String hostedZoneId;
        private String startRecordName;
        private String startRecordType;
        private String startRecordIdentifier;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceRecordSetsRequest model) {
            super(model);
            this.hostedZoneId(model.hostedZoneId);
            this.startRecordName(model.startRecordName);
            this.startRecordType(model.startRecordType);
            this.startRecordIdentifier(model.startRecordIdentifier);
            this.maxItems(model.maxItems);
        }

        public final String getHostedZoneId() {
            return this.hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        public final String getStartRecordName() {
            return this.startRecordName;
        }

        @Override
        public final Builder startRecordName(String startRecordName) {
            this.startRecordName = startRecordName;
            return this;
        }

        public final void setStartRecordName(String startRecordName) {
            this.startRecordName = startRecordName;
        }

        public final String getStartRecordType() {
            return this.startRecordType;
        }

        @Override
        public final Builder startRecordType(String startRecordType) {
            this.startRecordType = startRecordType;
            return this;
        }

        @Override
        public final Builder startRecordType(RRType startRecordType) {
            this.startRecordType(startRecordType == null ? null : startRecordType.toString());
            return this;
        }

        public final void setStartRecordType(String startRecordType) {
            this.startRecordType = startRecordType;
        }

        public final String getStartRecordIdentifier() {
            return this.startRecordIdentifier;
        }

        @Override
        public final Builder startRecordIdentifier(String startRecordIdentifier) {
            this.startRecordIdentifier = startRecordIdentifier;
            return this;
        }

        public final void setStartRecordIdentifier(String startRecordIdentifier) {
            this.startRecordIdentifier = startRecordIdentifier;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceRecordSetsRequest build() {
            return new ListResourceRecordSetsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListResourceRecordSetsRequest> {
        public Builder hostedZoneId(String var1);

        public Builder startRecordName(String var1);

        public Builder startRecordType(String var1);

        public Builder startRecordType(RRType var1);

        public Builder startRecordIdentifier(String var1);

        public Builder maxItems(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

