/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.route53.model.HealthCheckObservation;
import software.amazon.awssdk.services.route53.model.HealthCheckObservationsCopier;
import software.amazon.awssdk.services.route53.model.Route53Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHealthCheckStatusResponse
extends Route53Response
implements ToCopyableBuilder<Builder, GetHealthCheckStatusResponse> {
    private static final SdkField<List<HealthCheckObservation>> HEALTH_CHECK_OBSERVATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HealthCheckObservations").getter(GetHealthCheckStatusResponse.getter(GetHealthCheckStatusResponse::healthCheckObservations)).setter(GetHealthCheckStatusResponse.setter(Builder::healthCheckObservations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckObservations").unmarshallLocationName("HealthCheckObservations").build(), ListTrait.builder().memberLocationName("HealthCheckObservation").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HealthCheckObservation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckObservation").unmarshallLocationName("HealthCheckObservation").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECK_OBSERVATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetHealthCheckStatusResponse.memberNameToFieldInitializer();
    private final List<HealthCheckObservation> healthCheckObservations;

    private GetHealthCheckStatusResponse(BuilderImpl builder) {
        super(builder);
        this.healthCheckObservations = builder.healthCheckObservations;
    }

    public final boolean hasHealthCheckObservations() {
        return this.healthCheckObservations != null && !(this.healthCheckObservations instanceof SdkAutoConstructList);
    }

    public final List<HealthCheckObservation> healthCheckObservations() {
        return this.healthCheckObservations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHealthCheckObservations() ? this.healthCheckObservations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHealthCheckStatusResponse)) {
            return false;
        }
        GetHealthCheckStatusResponse other = (GetHealthCheckStatusResponse)((Object)obj);
        return this.hasHealthCheckObservations() == other.hasHealthCheckObservations() && Objects.equals(this.healthCheckObservations(), other.healthCheckObservations());
    }

    public final String toString() {
        return ToString.builder((String)"GetHealthCheckStatusResponse").add("HealthCheckObservations", this.hasHealthCheckObservations() ? this.healthCheckObservations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HealthCheckObservations": {
                return Optional.ofNullable(clazz.cast(this.healthCheckObservations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<HealthCheckObservation>>> map = new HashMap<String, SdkField<List<HealthCheckObservation>>>();
        map.put("HealthCheckObservations", HEALTH_CHECK_OBSERVATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHealthCheckStatusResponse, T> g) {
        return obj -> g.apply((GetHealthCheckStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Response.BuilderImpl
    implements Builder {
        private List<HealthCheckObservation> healthCheckObservations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetHealthCheckStatusResponse model) {
            super(model);
            this.healthCheckObservations(model.healthCheckObservations);
        }

        public final List<HealthCheckObservation.Builder> getHealthCheckObservations() {
            List<HealthCheckObservation.Builder> result = HealthCheckObservationsCopier.copyToBuilder(this.healthCheckObservations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHealthCheckObservations(Collection<HealthCheckObservation.BuilderImpl> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copyFromBuilder(healthCheckObservations);
        }

        @Override
        public final Builder healthCheckObservations(Collection<HealthCheckObservation> healthCheckObservations) {
            this.healthCheckObservations = HealthCheckObservationsCopier.copy(healthCheckObservations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(HealthCheckObservation ... healthCheckObservations) {
            this.healthCheckObservations(Arrays.asList(healthCheckObservations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder> ... healthCheckObservations) {
            this.healthCheckObservations(Stream.of(healthCheckObservations).map(c -> (HealthCheckObservation)((HealthCheckObservation.Builder)HealthCheckObservation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetHealthCheckStatusResponse build() {
            return new GetHealthCheckStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHealthCheckStatusResponse> {
        public Builder healthCheckObservations(Collection<HealthCheckObservation> var1);

        public Builder healthCheckObservations(HealthCheckObservation ... var1);

        public Builder healthCheckObservations(Consumer<HealthCheckObservation.Builder> ... var1);
    }
}

