/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53.model.Route53Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGeoLocationsRequest
extends Route53Request
implements ToCopyableBuilder<Builder, ListGeoLocationsRequest> {
    private static final SdkField<String> START_CONTINENT_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartContinentCode").getter(ListGeoLocationsRequest.getter(ListGeoLocationsRequest::startContinentCode)).setter(ListGeoLocationsRequest.setter(Builder::startContinentCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startcontinentcode").unmarshallLocationName("startcontinentcode").build()}).build();
    private static final SdkField<String> START_COUNTRY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartCountryCode").getter(ListGeoLocationsRequest.getter(ListGeoLocationsRequest::startCountryCode)).setter(ListGeoLocationsRequest.setter(Builder::startCountryCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startcountrycode").unmarshallLocationName("startcountrycode").build()}).build();
    private static final SdkField<String> START_SUBDIVISION_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartSubdivisionCode").getter(ListGeoLocationsRequest.getter(ListGeoLocationsRequest::startSubdivisionCode)).setter(ListGeoLocationsRequest.setter(Builder::startSubdivisionCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startsubdivisioncode").unmarshallLocationName("startsubdivisioncode").build()}).build();
    private static final SdkField<String> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxItems").getter(ListGeoLocationsRequest.getter(ListGeoLocationsRequest::maxItems)).setter(ListGeoLocationsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxitems").unmarshallLocationName("maxitems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_CONTINENT_CODE_FIELD, START_COUNTRY_CODE_FIELD, START_SUBDIVISION_CODE_FIELD, MAX_ITEMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGeoLocationsRequest.memberNameToFieldInitializer();
    private final String startContinentCode;
    private final String startCountryCode;
    private final String startSubdivisionCode;
    private final String maxItems;

    private ListGeoLocationsRequest(BuilderImpl builder) {
        super(builder);
        this.startContinentCode = builder.startContinentCode;
        this.startCountryCode = builder.startCountryCode;
        this.startSubdivisionCode = builder.startSubdivisionCode;
        this.maxItems = builder.maxItems;
    }

    public final String startContinentCode() {
        return this.startContinentCode;
    }

    public final String startCountryCode() {
        return this.startCountryCode;
    }

    public final String startSubdivisionCode() {
        return this.startSubdivisionCode;
    }

    public final String maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startContinentCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.startCountryCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.startSubdivisionCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGeoLocationsRequest)) {
            return false;
        }
        ListGeoLocationsRequest other = (ListGeoLocationsRequest)((Object)obj);
        return Objects.equals(this.startContinentCode(), other.startContinentCode()) && Objects.equals(this.startCountryCode(), other.startCountryCode()) && Objects.equals(this.startSubdivisionCode(), other.startSubdivisionCode()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public final String toString() {
        return ToString.builder((String)"ListGeoLocationsRequest").add("StartContinentCode", (Object)this.startContinentCode()).add("StartCountryCode", (Object)this.startCountryCode()).add("StartSubdivisionCode", (Object)this.startSubdivisionCode()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StartContinentCode": {
                return Optional.ofNullable(clazz.cast(this.startContinentCode()));
            }
            case "StartCountryCode": {
                return Optional.ofNullable(clazz.cast(this.startCountryCode()));
            }
            case "StartSubdivisionCode": {
                return Optional.ofNullable(clazz.cast(this.startSubdivisionCode()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("startcontinentcode", START_CONTINENT_CODE_FIELD);
        map.put("startcountrycode", START_COUNTRY_CODE_FIELD);
        map.put("startsubdivisioncode", START_SUBDIVISION_CODE_FIELD);
        map.put("maxitems", MAX_ITEMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGeoLocationsRequest, T> g) {
        return obj -> g.apply((ListGeoLocationsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Route53Request.BuilderImpl
    implements Builder {
        private String startContinentCode;
        private String startCountryCode;
        private String startSubdivisionCode;
        private String maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGeoLocationsRequest model) {
            super(model);
            this.startContinentCode(model.startContinentCode);
            this.startCountryCode(model.startCountryCode);
            this.startSubdivisionCode(model.startSubdivisionCode);
            this.maxItems(model.maxItems);
        }

        public final String getStartContinentCode() {
            return this.startContinentCode;
        }

        public final void setStartContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
        }

        @Override
        public final Builder startContinentCode(String startContinentCode) {
            this.startContinentCode = startContinentCode;
            return this;
        }

        public final String getStartCountryCode() {
            return this.startCountryCode;
        }

        public final void setStartCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
        }

        @Override
        public final Builder startCountryCode(String startCountryCode) {
            this.startCountryCode = startCountryCode;
            return this;
        }

        public final String getStartSubdivisionCode() {
            return this.startSubdivisionCode;
        }

        public final void setStartSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
        }

        @Override
        public final Builder startSubdivisionCode(String startSubdivisionCode) {
            this.startSubdivisionCode = startSubdivisionCode;
            return this;
        }

        public final String getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(String maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(String maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListGeoLocationsRequest build() {
            return new ListGeoLocationsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Route53Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGeoLocationsRequest> {
        public Builder startContinentCode(String var1);

        public Builder startCountryCode(String var1);

        public Builder startSubdivisionCode(String var1);

        public Builder maxItems(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

