/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.HumanTaskUiSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHumanTaskUisResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListHumanTaskUisResponse> {
    private static final SdkField<List<HumanTaskUiSummary>> HUMAN_TASK_UI_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HumanTaskUiSummaries").getter(ListHumanTaskUisResponse.getter(ListHumanTaskUisResponse::humanTaskUiSummaries)).setter(ListHumanTaskUisResponse.setter(Builder::humanTaskUiSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HumanTaskUiSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHumanTaskUisResponse.getter(ListHumanTaskUisResponse::nextToken)).setter(ListHumanTaskUisResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<HumanTaskUiSummary> humanTaskUiSummaries;
    private final String nextToken;

    private ListHumanTaskUisResponse(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiSummaries = builder.humanTaskUiSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHumanTaskUiSummaries() {
        return this.humanTaskUiSummaries != null && !(this.humanTaskUiSummaries instanceof SdkAutoConstructList);
    }

    public final List<HumanTaskUiSummary> humanTaskUiSummaries() {
        return this.humanTaskUiSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHumanTaskUiSummaries() ? this.humanTaskUiSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHumanTaskUisResponse)) {
            return false;
        }
        ListHumanTaskUisResponse other = (ListHumanTaskUisResponse)((Object)obj);
        return this.hasHumanTaskUiSummaries() == other.hasHumanTaskUiSummaries() && Objects.equals(this.humanTaskUiSummaries(), other.humanTaskUiSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHumanTaskUisResponse").add("HumanTaskUiSummaries", this.hasHumanTaskUiSummaries() ? this.humanTaskUiSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HumanTaskUiSummaries": {
                return Optional.ofNullable(clazz.cast(this.humanTaskUiSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHumanTaskUisResponse, T> g) {
        return obj -> g.apply((ListHumanTaskUisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<HumanTaskUiSummary> humanTaskUiSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHumanTaskUisResponse model) {
            super(model);
            this.humanTaskUiSummaries(model.humanTaskUiSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<HumanTaskUiSummary.Builder> getHumanTaskUiSummaries() {
            if (this.humanTaskUiSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.humanTaskUiSummaries != null ? (Collection)this.humanTaskUiSummaries.stream().map(HumanTaskUiSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder humanTaskUiSummaries(Collection<HumanTaskUiSummary> humanTaskUiSummaries) {
            this.humanTaskUiSummaries = HumanTaskUiSummariesCopier.copy(humanTaskUiSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanTaskUiSummaries(HumanTaskUiSummary ... humanTaskUiSummaries) {
            this.humanTaskUiSummaries(Arrays.asList(humanTaskUiSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder humanTaskUiSummaries(Consumer<HumanTaskUiSummary.Builder> ... humanTaskUiSummaries) {
            this.humanTaskUiSummaries(Stream.of(humanTaskUiSummaries).map(c -> (HumanTaskUiSummary)((HumanTaskUiSummary.Builder)HumanTaskUiSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHumanTaskUiSummaries(Collection<HumanTaskUiSummary.BuilderImpl> humanTaskUiSummaries) {
            this.humanTaskUiSummaries = HumanTaskUiSummariesCopier.copyFromBuilder(humanTaskUiSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListHumanTaskUisResponse build() {
            return new ListHumanTaskUisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHumanTaskUisResponse> {
        public Builder humanTaskUiSummaries(Collection<HumanTaskUiSummary> var1);

        public Builder humanTaskUiSummaries(HumanTaskUiSummary ... var1);

        public Builder humanTaskUiSummaries(Consumer<HumanTaskUiSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

