/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionSummary;
import software.amazon.awssdk.services.sagemaker.model.PipelineExecutionSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPipelineExecutionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListPipelineExecutionsResponse> {
    private static final SdkField<List<PipelineExecutionSummary>> PIPELINE_EXECUTION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PipelineExecutionSummaries").getter(ListPipelineExecutionsResponse.getter(ListPipelineExecutionsResponse::pipelineExecutionSummaries)).setter(ListPipelineExecutionsResponse.setter(Builder::pipelineExecutionSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PipelineExecutionSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PipelineExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPipelineExecutionsResponse.getter(ListPipelineExecutionsResponse::nextToken)).setter(ListPipelineExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PIPELINE_EXECUTION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<PipelineExecutionSummary> pipelineExecutionSummaries;
    private final String nextToken;

    private ListPipelineExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.pipelineExecutionSummaries = builder.pipelineExecutionSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPipelineExecutionSummaries() {
        return this.pipelineExecutionSummaries != null && !(this.pipelineExecutionSummaries instanceof SdkAutoConstructList);
    }

    public final List<PipelineExecutionSummary> pipelineExecutionSummaries() {
        return this.pipelineExecutionSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPipelineExecutionSummaries() ? this.pipelineExecutionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelineExecutionsResponse)) {
            return false;
        }
        ListPipelineExecutionsResponse other = (ListPipelineExecutionsResponse)((Object)obj);
        return this.hasPipelineExecutionSummaries() == other.hasPipelineExecutionSummaries() && Objects.equals(this.pipelineExecutionSummaries(), other.pipelineExecutionSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPipelineExecutionsResponse").add("PipelineExecutionSummaries", this.hasPipelineExecutionSummaries() ? this.pipelineExecutionSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PipelineExecutionSummaries": {
                return Optional.ofNullable(clazz.cast(this.pipelineExecutionSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPipelineExecutionsResponse, T> g) {
        return obj -> g.apply((ListPipelineExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<PipelineExecutionSummary> pipelineExecutionSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPipelineExecutionsResponse model) {
            super(model);
            this.pipelineExecutionSummaries(model.pipelineExecutionSummaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<PipelineExecutionSummary.Builder> getPipelineExecutionSummaries() {
            if (this.pipelineExecutionSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pipelineExecutionSummaries != null ? (Collection)this.pipelineExecutionSummaries.stream().map(PipelineExecutionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copy(pipelineExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSummaries(PipelineExecutionSummary ... pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries(Arrays.asList(pipelineExecutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pipelineExecutionSummaries(Consumer<PipelineExecutionSummary.Builder> ... pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries(Stream.of(pipelineExecutionSummaries).map(c -> (PipelineExecutionSummary)((PipelineExecutionSummary.Builder)PipelineExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPipelineExecutionSummaries(Collection<PipelineExecutionSummary.BuilderImpl> pipelineExecutionSummaries) {
            this.pipelineExecutionSummaries = PipelineExecutionSummaryListCopier.copyFromBuilder(pipelineExecutionSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPipelineExecutionsResponse build() {
            return new ListPipelineExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPipelineExecutionsResponse> {
        public Builder pipelineExecutionSummaries(Collection<PipelineExecutionSummary> var1);

        public Builder pipelineExecutionSummaries(PipelineExecutionSummary ... var1);

        public Builder pipelineExecutionSummaries(Consumer<PipelineExecutionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

